/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression.ast;

import java.util.Set;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.EvaluationException;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfExpression
extends Expression {
    private Expression condition;
    private Expression thenPart;
    private Expression elsePart;

    public IfExpression(Expression condition, Expression thenPart, Expression elsePart) {
        this.condition = condition;
        this.thenPart = thenPart;
        this.elsePart = elsePart;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getElsePart() {
        return this.elsePart;
    }

    public Expression getThenPart() {
        return this.thenPart;
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Object val = this.getCondition().evaluate(ctx);
        if (val == null) {
            val = Boolean.FALSE;
        }
        if (!(val instanceof Boolean)) {
            throw new EvaluationException("Boolean expected!", (SyntaxElement)this.getCondition(), ctx);
        }
        if (((Boolean)val).booleanValue()) {
            return this.getThenPart().evaluate(ctx);
        }
        if (this.getElsePart() == null) {
            return null;
        }
        return this.getElsePart().evaluate(ctx);
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type elsePartType;
        Type conditionType = this.getCondition().analyze(ctx, issues);
        if (conditionType != null && !conditionType.equals(ctx.getBooleanType())) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "Boolean expected", this.getCondition()));
        }
        Type thenPartType = this.getThenPart().analyze(ctx, issues);
        Type type = elsePartType = this.getElsePart() != null ? this.getElsePart().analyze(ctx, issues) : ctx.getVoidType();
        if (thenPartType == null || elsePartType == null) {
            return null;
        }
        if (thenPartType.isAssignableFrom(elsePartType)) {
            return elsePartType;
        }
        if (elsePartType.isAssignableFrom(thenPartType)) {
            return thenPartType;
        }
        return ctx.getObjectType();
    }

    @Override
    protected String toStringInternal() {
        return "if " + this.condition.toString() + " then " + this.thenPart + (this.elsePart != null ? " else " + this.elsePart : "");
    }
}

