/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression.ast;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.Variable;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.Identifier;
import org.openarchitectureware.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalVarExpression
extends Expression {
    private Log logger = LogFactory.getLog(this.getClass());
    private Identifier globalVarName;

    public GlobalVarExpression(Identifier globalVarName) {
        this.globalVarName = globalVarName;
    }

    public String getVarName() {
        return this.globalVarName.getValue();
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Variable o = ctx.getGlobalVariables().get(this.globalVarName.getValue());
        if (o == null) {
            this.logger.warn((Object)("Global variable '" + this.globalVarName.getValue() + "' is null. Is it configured?"));
            return null;
        }
        return o.getValue();
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        return ctx.getObjectType();
    }

    @Override
    protected String toStringInternal() {
        return "var " + this.globalVarName.getValue();
    }
}

