/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.expression.ast;

import java.util.Set;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.EvaluationException;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.Identifier;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorCallExpression
extends Expression {
    private Identifier type;

    public ConstructorCallExpression(Identifier type) {
        this.type = type;
    }

    public String getTypeName() {
        return this.type.getValue();
    }

    @Override
    protected Object evaluateInternal(ExecutionContext ctx) {
        Type t = ctx.getTypeForName(this.type.getValue());
        if (t != null) {
            return t.newInstance();
        }
        throw new EvaluationException("Couldn't find type " + this.type, (SyntaxElement)this, ctx);
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type t = ctx.getTypeForName(this.type.getValue());
        if (t == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Type not found : " + this.type, this.type));
        }
        return t;
    }

    @Override
    protected String toStringInternal() {
        return "new " + this.getTypeName();
    }
}

