/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

final class DummyWindowManager
extends WindowManager {
    private static final long serialVersionUID = 1L;
    private final Map workspaces;
    private transient Frame mw;
    private transient PropertyChangeSupport pcs;
    private transient R r;

    public DummyWindowManager() {
        System.err.println("OK");
        this.workspaces = new TreeMap();
        this.createWorkspace("default", null);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    protected TopComponent.Registry componentRegistry() {
        TopComponent.Registry reg = super.componentRegistry();
        if (reg != null) {
            return reg;
        }
        return this.registry();
    }

    synchronized R registry() {
        if (this.r == null) {
            this.r = new R();
        }
        return this.r;
    }

    protected WindowManager.Component createTopComponentManager(TopComponent c) {
        return new TCM(c);
    }

    public synchronized Workspace createWorkspace(String name, String displayName) {
        W w = new W(name);
        this.workspaces.put(name, w);
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
        return w;
    }

    synchronized void delete(Workspace w) {
        this.workspaces.remove(w.getName());
        if (this.workspaces.isEmpty()) {
            this.createWorkspace("default", null);
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
    }

    public synchronized Workspace findWorkspace(String name) {
        return (Workspace)this.workspaces.get(name);
    }

    public synchronized Workspace getCurrentWorkspace() {
        return (Workspace)this.workspaces.values().iterator().next();
    }

    public synchronized Workspace[] getWorkspaces() {
        return this.workspaces.values().toArray(new Workspace[0]);
    }

    public synchronized void setWorkspaces(Workspace[] ws) {
        if (ws.length == 0) {
            throw new IllegalArgumentException();
        }
        this.workspaces.clear();
        int i = 0;
        while (i < ws.length) {
            this.workspaces.put(ws[i].getName(), ws[i]);
            ++i;
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
    }

    public synchronized Frame getMainWindow() {
        if (this.mw == null) {
            this.mw = new JFrame("dummy");
        }
        return this.mw;
    }

    public void updateUI() {
    }

    private final class R
    implements TopComponent.Registry {
        private TopComponent active;
        private final Set opened = new HashSet();
        private Node[] nodes = new Node[0];
        private PropertyChangeSupport pcs;

        public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            this.pcs.addPropertyChangeListener(l);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
            if (this.pcs != null) {
                this.pcs.removePropertyChangeListener(l);
            }
        }

        synchronized void open(TopComponent tc) {
            this.opened.add(tc);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("opened", null, null);
            }
        }

        synchronized void close(TopComponent tc) {
            this.opened.remove(tc);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("opened", null, null);
            }
        }

        public synchronized Set getOpened() {
            return new HashSet(this.opened);
        }

        synchronized void setActive(TopComponent tc) {
            this.active = tc;
            Node[] _nodes = tc.getActivatedNodes();
            if (_nodes != null) {
                this.nodes = _nodes;
                if (this.pcs != null) {
                    this.pcs.firePropertyChange("activatedNodes", null, null);
                }
            }
            if (this.pcs != null) {
                this.pcs.firePropertyChange("activated", null, null);
                this.pcs.firePropertyChange("currentNodes", null, null);
            }
        }

        synchronized void setActivatedNodes(TopComponent tc, Node[] _nodes) {
            if (tc == this.active) {
                if (_nodes != null) {
                    this.nodes = _nodes;
                    if (this.pcs != null) {
                        this.pcs.firePropertyChange("activatedNodes", null, null);
                    }
                }
                if (this.pcs != null) {
                    this.pcs.firePropertyChange("currentNodes", null, null);
                }
            }
        }

        public TopComponent getActivated() {
            return this.active;
        }

        public Node[] getActivatedNodes() {
            return this.nodes;
        }

        public synchronized Node[] getCurrentNodes() {
            if (this.active != null) {
                return this.active.getActivatedNodes();
            }
            return null;
        }
    }

    private final class W
    implements Workspace {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Map modes = new HashMap();
        private final Map modesByComponent = new WeakHashMap();
        private transient PropertyChangeSupport pcs;

        public W(String name) {
            this.name = name;
        }

        public void activate() {
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener list) {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            this.pcs.addPropertyChangeListener(list);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener list) {
            if (this.pcs != null) {
                this.pcs.removePropertyChangeListener(list);
            }
        }

        public void remove() {
            DummyWindowManager.this.delete(this);
        }

        public synchronized Mode createMode(String name, String displayName, URL icon) {
            M m = new M(name);
            this.modes.put(name, m);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("modes", null, null);
            }
            return m;
        }

        public synchronized Set getModes() {
            return new HashSet(this.modes.values());
        }

        public synchronized Mode findMode(String name) {
            return (Mode)this.modes.get(name);
        }

        public synchronized Mode findMode(TopComponent c) {
            return (Mode)this.modesByComponent.get(c);
        }

        synchronized void dock(Mode m, TopComponent c) {
            this.modesByComponent.put(c, m);
        }

        public Rectangle getBounds() {
            return Utilities.getUsableScreenBounds();
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.getName();
        }

        private final class M
        implements Mode {
            private static final long serialVersionUID = 1L;
            private final String name;
            private final Set components = new HashSet();

            public M(String name) {
                this.name = name;
            }

            public void addPropertyChangeListener(PropertyChangeListener l) {
            }

            public void removePropertyChangeListener(PropertyChangeListener l) {
            }

            public boolean canDock(TopComponent tc) {
                return true;
            }

            public synchronized boolean dockInto(TopComponent c) {
                if (this.components.add(c)) {
                    Mode old = W.this.findMode(c);
                    if (old != null && old != this && old instanceof M) {
                        Mode mode = old;
                        synchronized (mode) {
                            ((M)old).components.remove(c);
                        }
                    }
                    W.this.dock(this, c);
                }
                return true;
            }

            public String getName() {
                return this.name;
            }

            public String getDisplayName() {
                return this.getName();
            }

            public Image getIcon() {
                return null;
            }

            public synchronized TopComponent[] getTopComponents() {
                return this.components.toArray(new TopComponent[0]);
            }

            public Workspace getWorkspace() {
                return W.this;
            }

            public synchronized Rectangle getBounds() {
                return W.this.getBounds();
            }

            public void setBounds(Rectangle s) {
            }
        }
    }

    private final class TCM
    implements WindowManager.Component {
        private static final long serialVersionUID = 1L;
        private final TopComponent tc;
        private transient JFrame f;
        private Image icon;
        private final Set workspaces = new HashSet();
        private transient Node[] nodes;

        public TCM(TopComponent tc) {
            this.tc = tc;
        }

        public void open() {
            this.open(DummyWindowManager.this.getCurrentWorkspace());
        }

        public synchronized void open(Workspace workspace) {
            if (this.f == null) {
                this.f = new JFrame(this.tc.getName());
                if (this.icon != null) {
                    ((Frame)this.f).setIconImage(this.icon);
                }
                this.f.getContentPane().add(this.tc);
                this.f.pack();
                this.f.addWindowListener(new WindowAdapter(this, workspace){
                    private final /* synthetic */ Workspace val$workspace;
                    private final /* synthetic */ TCM this$1;
                    {
                        this.this$1 = this$1;
                        this.val$workspace = val$workspace;
                    }

                    public void windowClosing(WindowEvent ev) {
                        this.this$1.close(this.val$workspace);
                    }
                });
            }
            this.f.show();
            this.workspaces.add(workspace);
            DummyWindowManager.this.registry().open(this.tc);
        }

        public synchronized void close(Workspace workspace) {
            if (this.f != null) {
                ((Component)this.f).setVisible(false);
            }
            this.workspaces.remove(workspace);
            DummyWindowManager.this.registry().close(this.tc);
        }

        public synchronized Set whereOpened() {
            return this.workspaces;
        }

        public Node[] getActivatedNodes() {
            return this.nodes;
        }

        public void setActivatedNodes(Node[] nodes) {
            this.nodes = nodes;
            DummyWindowManager.this.registry().setActivatedNodes(this.tc, nodes);
        }

        public synchronized void nameChanged() {
            if (this.f != null) {
                this.f.setTitle(this.tc.getName());
            }
        }

        public void requestFocus() {
            DummyWindowManager.this.registry().setActive(this.tc);
        }

        public void requestVisible() {
            if (this.f != null) {
                this.f.show();
            }
        }

        public Image getIcon() {
            return this.icon;
        }

        public void setIcon(Image icon) {
            this.icon = icon;
            if (this.f != null && icon != null) {
                ((Frame)this.f).setIconImage(icon);
            }
        }
    }
}

