/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.OpenSupport;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;

public class DataEditorSupport
extends CloneableEditorSupport {
    private final DataObject obj;
    private NodeListener nodeL;
    static /* synthetic */ Class class$org$openide$text$DataEditorSupport;

    public DataEditorSupport(DataObject obj, CloneableEditorSupport.Env env) {
        super(env);
        this.obj = obj;
    }

    public final DataObject getDataObject() {
        return this.obj;
    }

    protected String messageOpening() {
        return NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "CTL_ObjectOpen", this.obj.getName(), this.obj.getPrimaryFile().toString());
    }

    protected String messageOpened() {
        return NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "CTL_ObjectOpened", this.obj.getName(), this.obj.getPrimaryFile().toString());
    }

    protected String messageSave() {
        return NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "MSG_SaveFile", this.obj.getName());
    }

    protected String messageName() {
        if (!this.obj.isValid()) {
            return "";
        }
        String name = this.obj.getNodeDelegate().getDisplayName();
        int version = 3;
        if (this.isModified()) {
            version = this.obj.getPrimaryFile().isReadOnly() ? 2 : 1;
        } else if (this.obj.getPrimaryFile().isReadOnly()) {
            version = 0;
        }
        return NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "LAB_EditorName", new Integer(version), name);
    }

    protected String messageToolTip() {
        FileObject fo = this.obj.getPrimaryFile();
        try {
            File f = FileUtil.toFile(fo);
            if (f != null) {
                return f.getAbsolutePath();
            }
            return NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "LAB_EditorToolTip", new Object[]{fo.getPath(), fo.getFileSystem().getDisplayName()});
        }
        catch (FileStateInvalidException fsie) {
            return fo.getPath();
        }
    }

    protected void initializeCloneableEditor(CloneableEditor editor) {
        if (this.obj.isValid()) {
            Node ourNode = this.obj.getNodeDelegate();
            editor.setActivatedNodes(new Node[]{ourNode});
            editor.setIcon(ourNode.getIcon(1));
            DataNodeListener nl = new DataNodeListener(editor);
            ourNode.addNodeListener(WeakListener.node(nl, ourNode));
            this.nodeL = nl;
        }
    }

    protected void notifyClosed() {
        this.nodeL = null;
        super.notifyClosed();
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument doc = super.createStyledDocument(kit);
        doc.putProperty("title", this.obj.getPrimaryFile().getPath());
        doc.putProperty("stream", this.obj);
        return doc;
    }

    protected boolean canClose() {
        if (this.env().isModified() && this.isEnvReadOnly()) {
            Object result = DialogDisplayer.getDefault().notify(new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "MSG_FileReadOnlyClosing", new Object[]{((Env)this.env).getFileImpl().getNameExt()}), 2, 2));
            return result == NotifyDescriptor.OK_OPTION;
        }
        return super.canClose();
    }

    public void saveDocument() throws IOException {
        if (this.env().isModified() && this.isEnvReadOnly()) {
            DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(NbBundle.getMessage(class$org$openide$text$DataEditorSupport == null ? (class$org$openide$text$DataEditorSupport = DataEditorSupport.class$("org.openide.text.DataEditorSupport")) : class$org$openide$text$DataEditorSupport, "MSG_FileReadOnlySaving", new Object[]{((Env)this.env).getFileImpl().getNameExt()}), 2));
            return;
        }
        super.saveDocument();
    }

    boolean isEnvReadOnly() {
        CloneableEditorSupport.Env env = this.env();
        return env instanceof Env && ((Env)env).getFileImpl().isReadOnly();
    }

    final DataObject getDataObjectHack() {
        return this.obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class DataNodeListener
    extends NodeAdapter {
        CloneableEditor editor;

        DataNodeListener(CloneableEditor editor) {
            this.editor = editor;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if ("displayName".equals(ev.getPropertyName())) {
                DataEditorSupport.this.updateTitles();
            }
            if ("icon".equals(ev.getPropertyName()) && DataEditorSupport.this.obj.isValid()) {
                this.editor.setIcon(DataEditorSupport.this.obj.getNodeDelegate().getIcon(1));
            }
        }
    }

    private static final class EnvListener
    extends FileChangeAdapter {
        private Reference env;

        public EnvListener(Env env) {
            this.env = new WeakReference<Env>(env);
        }

        public void fileDeleted(FileEvent fe) {
            Env env = (Env)this.env.get();
            FileObject fo = fe.getFile();
            if (env == null || env.getFileImpl() != fo) {
                fo.removeFileChangeListener(this);
                return;
            }
            fo.removeFileChangeListener(this);
            env.fileRemoved(false);
            fo.addFileChangeListener(this);
        }

        public void fileChanged(FileEvent fe) {
            Env env = (Env)this.env.get();
            if (env == null || env.getFileImpl() != fe.getFile()) {
                fe.getFile().removeFileChangeListener(this);
                return;
            }
            if (fe.getFile().isVirtual()) {
                fe.getFile().removeFileChangeListener(this);
                env.fileRemoved(true);
                fe.getFile().addFileChangeListener(this);
            } else {
                env.fileChanged(fe.isExpected(), fe.getTime());
            }
        }
    }

    public static abstract class Env
    extends OpenSupport.Env
    implements CloneableEditorSupport.Env,
    Serializable,
    PropertyChangeListener,
    VetoableChangeListener {
        static final long serialVersionUID = -2945098431098324441L;
        private transient FileObject fileObject;
        private transient FileLock fileLock;

        public Env(DataObject obj) {
            super(obj);
        }

        private FileObject getFileImpl() {
            this.changeFile();
            return this.fileObject;
        }

        protected abstract FileObject getFile();

        protected abstract FileLock takeLock() throws IOException;

        protected final void changeFile() {
            boolean lockAgain;
            FileObject newFile = this.getFile();
            if (newFile.equals(this.fileObject)) {
                return;
            }
            if (this.fileLock != null) {
                this.fileLock.releaseLock();
                lockAgain = true;
            } else {
                lockAgain = false;
            }
            this.fileObject = newFile;
            this.fileObject.addFileChangeListener(new EnvListener(this));
            if (lockAgain) {
                try {
                    this.fileLock = this.takeLock();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, e);
                }
            }
        }

        public InputStream inputStream() throws IOException {
            InputStream is = this.getFileImpl().getInputStream();
            return is;
        }

        public OutputStream outputStream() throws IOException {
            return this.getFileImpl().getOutputStream(this.fileLock);
        }

        public Date getTime() {
            this.getFileImpl().refresh(false);
            return this.getFileImpl().lastModified();
        }

        public String getMimeType() {
            return this.getFileImpl().getMIMEType();
        }

        public void markModified() throws IOException {
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.takeLock();
            }
            if (this.getFileImpl().isReadOnly()) {
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.releaseLock();
                }
                throw new IOException("File " + this.getFileImpl().getNameExt() + " is read-only!");
            }
            this.getDataObject().setModified(true);
        }

        public void unmarkModified() {
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.releaseLock();
            }
            this.getDataObject().setModified(false);
        }

        final void fileChanged(boolean expected, long time) {
            if (expected) {
                this.firePropertyChange("time", null, null);
            } else {
                this.firePropertyChange("time", null, new Date(time));
            }
        }

        private void fileRemoved(boolean canBeVetoed) {
            if (canBeVetoed) {
                try {
                    this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }
    }
}

