/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.debug;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.ISyntaxElement;
import org.openarchitectureware.expression.debug.EvaluatedElementWrapper;
import org.openarchitectureware.expression.debug.NoResourceSpecial;
import org.openarchitectureware.workflow.util.PluginConfigurationElementUtil;
import org.openarchitectureware.xpand2.XpandEditorPlugin;
import org.openarchitectureware.xpand2.ast.AbstractDefinition;
import org.openarchitectureware.xpand2.ast.ErrorStatement;
import org.openarchitectureware.xpand2.ast.ExpandStatement;
import org.openarchitectureware.xpand2.ast.ExpressionStatement;
import org.openarchitectureware.xpand2.ast.FileStatement;
import org.openarchitectureware.xpand2.ast.ForEachStatement;
import org.openarchitectureware.xpand2.ast.IfStatement;
import org.openarchitectureware.xpand2.ast.LetStatement;
import org.openarchitectureware.xpand2.ast.ProtectStatement;
import org.openarchitectureware.xpand2.ast.Statement;
import org.openarchitectureware.xpand2.ast.Template;
import org.openarchitectureware.xpand2.ast.TextStatement;
import org.openarchitectureware.xpand2.debug.ExpandSpecial;
import org.openarchitectureware.xpand2.debug.ForEachSpecial;
import org.openarchitectureware.xpand2.debug.IfSpecial;
import org.openarchitectureware.xpand2.debug.XpandModelPresentation;
import org.openarchitectureware.xpand2.editor.XpandEditor;
import org.openarchitectureware.xpand2.internal.XpandLog;
import org.openarchitectureware.xpand2.model.XpandAdvice;
import org.openarchitectureware.xpand2.model.XpandDefinition;
import org.openarchitectureware.xtend.debug.ExpressionPluginAdapter;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandPluginAdapter
extends ExpressionPluginAdapter {
    private Image icon = null;

    public XpandPluginAdapter() {
        this.specials.add(new ForEachSpecial());
        this.specials.add(new ExpandSpecial());
        this.specials.add(new IfSpecial());
        this.specials.add(new NoResourceSpecial());
        this.pres = new XpandModelPresentation(this.specials);
    }

    protected String getRequiredExtension() {
        return "xpt";
    }

    public boolean canHandleType(String type) {
        return "xpand".equals(type);
    }

    public String getEditorId() {
        return PluginConfigurationElementUtil.getConfigAttribute((String)("org.eclipse.ui.editors/editor[class=" + XpandEditor.class.getName() + "]/id"));
    }

    protected List<ISyntaxElement> collectFirstLevelElements(IOawResource res) {
        XpandAdvice[] advs;
        XpandDefinition[] defs;
        ArrayList<ISyntaxElement> result = new ArrayList<ISyntaxElement>();
        XpandDefinition[] xpandDefinitionArray = defs = ((Template)res.getOawResource()).getDefinitions();
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            XpandDefinition def = xpandDefinitionArray[n2];
            result.add((ISyntaxElement)def);
            ++n2;
        }
        XpandAdvice[] xpandAdviceArray = advs = ((Template)res.getOawResource()).getAdvices();
        int n3 = advs.length;
        n = 0;
        while (n < n3) {
            XpandAdvice adv = xpandAdviceArray[n];
            result.add((ISyntaxElement)adv);
            ++n;
        }
        return result;
    }

    protected List<ISyntaxElement> getBody(ISyntaxElement parent) {
        ArrayList<ISyntaxElement> result = new ArrayList<ISyntaxElement>();
        if (parent instanceof AbstractDefinition) {
            result.addAll(((AbstractDefinition)parent).getBodyAsList());
        } else if (!(parent instanceof TextStatement)) {
            if (parent instanceof FileStatement) {
                FileStatement stmt = (FileStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)stmt.getTargetFileName());
                result.addAll(stmt.getBodyAsList());
            } else if (parent instanceof ForEachStatement) {
                ForEachStatement stmt = (ForEachStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)stmt.getTarget());
                result.add((ISyntaxElement)stmt.getSeparator());
                result.addAll(stmt.getBodyAsList());
            } else if (parent instanceof IfStatement) {
                IfStatement stmt = (IfStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)stmt.getCondition());
                result.addAll(stmt.getBodyAsList());
                result.add((ISyntaxElement)stmt.getElseIf());
            } else if (parent instanceof LetStatement) {
                LetStatement stmt = (LetStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)stmt.getVarValue());
                result.addAll(stmt.getBodyAsList());
            } else if (parent instanceof ProtectStatement) {
                ProtectStatement stmt = (ProtectStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)stmt.getCommentStart());
                result.add((ISyntaxElement)stmt.getCommentEnd());
                result.add((ISyntaxElement)stmt.getId());
                result.addAll(stmt.getBodyAsList());
            } else if (parent instanceof ErrorStatement) {
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)((ErrorStatement)parent).getMessage());
            } else if (parent instanceof ExpandStatement) {
                Expression sep;
                ExpandStatement stmt = (ExpandStatement)parent;
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.addAll(stmt.getParametersAsList());
                Expression target = ((ExpandStatement)parent).getTarget();
                if (target != null) {
                    result.add((ISyntaxElement)target);
                }
                if ((sep = ((ExpandStatement)parent).getSeparator()) != null) {
                    result.add((ISyntaxElement)sep);
                }
            } else if (parent instanceof ExpressionStatement) {
                result.add((ISyntaxElement)new EvaluatedElementWrapper(parent));
                result.add((ISyntaxElement)((ExpressionStatement)parent).getExpression());
            } else if (parent instanceof Statement) {
                XpandLog.logInfo("Implementation error: Wanted to set Breakpoint for unknown statement: " + parent.getClass().getSimpleName());
            } else {
                result.addAll(super.getBody(parent));
            }
        }
        return result;
    }

    protected boolean isValidReturnElement(ISyntaxElement element) {
        if (element instanceof TextStatement) {
            return false;
        }
        if (element instanceof Statement) {
            return true;
        }
        return super.isValidReturnElement(element);
    }

    public Image getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        Path path = new Path("/icons/templatefile.gif");
        InputStream is = null;
        try {
            is = FileLocator.openStream((Bundle)XpandEditorPlugin.getDefault().getBundle(), (IPath)path, (boolean)false);
        }
        catch (IOException iOException) {}
        if (is != null) {
            ImageData iData = new ImageData(is);
            this.icon = new Image((Device)Display.getCurrent(), iData);
            return this.icon;
        }
        return null;
    }
}

