/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.parser;

import java.util.ArrayList;
import java.util.List;
import org.openarchitectureware.expression.ast.DeclaredParameter;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.Identifier;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.expression.parser.ExpressionFactory;
import org.openarchitectureware.xpand2.ast.Advice;
import org.openarchitectureware.xpand2.ast.Definition;
import org.openarchitectureware.xpand2.ast.ErrorStatement;
import org.openarchitectureware.xpand2.ast.ExpandStatement;
import org.openarchitectureware.xpand2.ast.ExpressionStatement;
import org.openarchitectureware.xpand2.ast.FileStatement;
import org.openarchitectureware.xpand2.ast.ForEachStatement;
import org.openarchitectureware.xpand2.ast.IfStatement;
import org.openarchitectureware.xpand2.ast.ImportDeclaration;
import org.openarchitectureware.xpand2.ast.LetStatement;
import org.openarchitectureware.xpand2.ast.ProtectStatement;
import org.openarchitectureware.xpand2.ast.Statement;
import org.openarchitectureware.xpand2.ast.Template;
import org.openarchitectureware.xpand2.ast.TextStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandFactory
extends ExpressionFactory {
    public XpandFactory(String fileName) {
        super(fileName);
    }

    public Template createTemplate(List<SyntaxElement> imports, List<SyntaxElement> extensions, List<SyntaxElement> defines, List<SyntaxElement> advices) {
        ImportDeclaration[] i = this.check(imports).toArray(new ImportDeclaration[this.check(imports).size()]);
        ImportDeclaration[] ext = this.check(extensions).toArray(new ImportDeclaration[this.check(extensions).size()]);
        Definition[] d = this.check(defines).toArray(new Definition[this.check(defines).size()]);
        Advice[] a = this.check(advices).toArray(new Advice[this.check(advices).size()]);
        Template t = new Template(i, ext, d, a);
        return (Template)this.handle(t);
    }

    public Definition createDefinition(Identifier name, List<DeclaredParameter> p, Identifier type, List<Statement> s) {
        DeclaredParameter[] params = this.check(p).toArray(new DeclaredParameter[this.check(p).size()]);
        Statement[] body = this.check(s).toArray(new Statement[this.check(s).size()]);
        Definition def = new Definition(name, type, params, body);
        Statement[] statementArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            Statement element = statementArray[n2];
            element.setContainingDefinition(def);
            ++n2;
        }
        return (Definition)this.handle(def);
    }

    private <T> List<T> check(List<T> p) {
        if (p == null) {
            return new ArrayList();
        }
        p.remove(null);
        return p;
    }

    public TextStatement createTextStatement(Identifier t, Identifier identifier) {
        String txt = t.getValue();
        if (txt.startsWith("\u00bb") && txt.endsWith("\u00ab")) {
            txt = txt.substring(1, txt.length() - 1);
        }
        return (TextStatement)this.handle(new TextStatement(txt, identifier != null));
    }

    public ForEachStatement createForEachStatement(Expression e, Identifier v, Expression sep, Identifier iter, List<Statement> s) {
        Statement[] body = this.check(s).toArray(new Statement[this.check(s).size()]);
        return (ForEachStatement)this.handle(new ForEachStatement(v, e, body, sep, iter));
    }

    public IfStatement createIfStatement(Expression condition, List<Statement> s) {
        Statement[] body = this.check(s).toArray(new Statement[this.check(s).size()]);
        return (IfStatement)this.handle(new IfStatement(condition, body));
    }

    public LetStatement createLetStatement(Expression e, Identifier name, List<Statement> s) {
        Statement[] body = this.check(s).toArray(new Statement[this.check(s).size()]);
        return (LetStatement)this.handle(new LetStatement(name, e, body));
    }

    public ErrorStatement createErrorStatement(Expression expr) {
        return (ErrorStatement)this.handle(new ErrorStatement(expr));
    }

    public ExpressionStatement createExpressionStatement(Expression e) {
        return (ExpressionStatement)this.handle(new ExpressionStatement(e));
    }

    public FileStatement createFileStatement(Expression fileName, Identifier option, List<Statement> s) {
        Statement[] body = this.check(s).toArray(new Statement[this.check(s).size()]);
        return (FileStatement)this.handle(new FileStatement(fileName, body, option));
    }

    public ProtectStatement createProtectStatement(Expression startC, Expression endC, Expression id, boolean disabled, List<Statement> s) {
        Statement[] body = this.check(s).toArray(new Statement[this.check(s).size()]);
        return (ProtectStatement)this.handle(new ProtectStatement(startC, endC, body, id, disabled));
    }

    public ExpandStatement createExpandStatement(Identifier definition, List<Expression> parameters, Expression target, boolean foreach, Expression sep) {
        Expression[] params = this.check(parameters).toArray(new Expression[this.check(parameters).size()]);
        return (ExpandStatement)this.handle(new ExpandStatement(definition, target, sep, params, foreach));
    }

    public ImportDeclaration createImportDeclaration(Identifier namespace) {
        return (ImportDeclaration)this.handle(new ImportDeclaration(namespace));
    }

    public Advice createAround(Identifier n, List<DeclaredParameter> p, boolean wildparams, Identifier t, List<Statement> s) {
        DeclaredParameter[] params = this.check(p).toArray(new DeclaredParameter[this.check(p).size()]);
        Statement[] body = this.check(s).toArray(new Statement[this.check(s).size()]);
        Advice a = new Advice(n, t, params, wildparams, body);
        Statement[] statementArray = body;
        int n2 = body.length;
        int n3 = 0;
        while (n3 < n2) {
            Statement element = statementArray[n3];
            element.setContainingDefinition(a);
            ++n3;
        }
        return (Advice)this.handle(a);
    }
}

