/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.codeassist.ProposalComputer;
import org.openarchitectureware.expression.codeassist.ProposalFactory;
import org.openarchitectureware.xpand2.XpandExecutionContext;
import org.openarchitectureware.xpand2.codeassist.FastAnalyzer;
import org.openarchitectureware.xpand2.model.XpandDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpandProposalComputer
implements ProposalComputer {
    private static final Pattern p = FastAnalyzer.EXPAND_PATTERN;

    public List<Object> computeProposals(String txt, ExecutionContext ctx, ProposalFactory factory) {
        ArrayList<Object> result = new ArrayList<Object>();
        Matcher m = p.matcher(txt);
        if (m.find()) {
            XpandExecutionContext xpandCtx;
            List<XpandDefinition> allDefinitions;
            String prefix = m.group(1);
            if (ctx instanceof XpandExecutionContext && (allDefinitions = (xpandCtx = (XpandExecutionContext)ctx).getAllDefinitions()) != null) {
                for (XpandDefinition xpandDefinition : allDefinitions) {
                    String defineName = xpandDefinition.getName();
                    result.add(factory.createDefinitionProposal(defineName, defineName, prefix));
                }
            }
        }
        return result;
    }
}

