/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xpand2.ast;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.expression.AnalysationIssue;
import org.openarchitectureware.expression.EvaluationException;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.Variable;
import org.openarchitectureware.expression.ast.Expression;
import org.openarchitectureware.expression.ast.Identifier;
import org.openarchitectureware.expression.ast.SyntaxElement;
import org.openarchitectureware.type.Type;
import org.openarchitectureware.xpand2.XpandExecutionContext;
import org.openarchitectureware.xpand2.ast.Statement;
import org.openarchitectureware.xpand2.ast.StatementWithBody;
import org.openarchitectureware.xpand2.output.VetoException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatement
extends StatementWithBody {
    private static final Log LOG = LogFactory.getLog(FileStatement.class);
    private Expression fileNameExpression;
    private Identifier outletNameIdentifier;

    public FileStatement(Expression fileName, Statement[] body, Identifier mode) {
        super(body);
        this.fileNameExpression = fileName;
        this.outletNameIdentifier = mode;
    }

    public Expression getTargetFileName() {
        return this.fileNameExpression;
    }

    public Identifier getMode() {
        return this.outletNameIdentifier;
    }

    public String getOutletName() {
        if (this.outletNameIdentifier == null) {
            return null;
        }
        return this.outletNameIdentifier.getValue();
    }

    @Override
    public void analyzeInternal(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type result = this.getTargetFileName().analyze((ExecutionContext)ctx, issues);
        if (!(ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable("FILENAME", (Object)result))).getStringType().isAssignableFrom(result)) {
            issues.add(new AnalysationIssue(AnalysationIssue.INCOMPATIBLE_TYPES, "String expected!", (SyntaxElement)this.getTargetFileName()));
        }
        int i = 0;
        while (i < this.body.length) {
            this.body[i].analyze(ctx, issues);
            ++i;
        }
    }

    @Override
    public void evaluateInternal(XpandExecutionContext ctx) {
        block3: {
            Object result = this.getFilename(ctx);
            String fileName = result.toString();
            String outletName = this.getOutletName();
            ctx = (XpandExecutionContext)ctx.cloneWithVariable(new Variable("FILENAME", result));
            try {
                ctx.getOutput().openFile(fileName, outletName);
                int i = 0;
                while (i < this.body.length) {
                    this.body[i].evaluate(ctx);
                    ++i;
                }
                ctx.getOutput().closeFile();
            }
            catch (VetoException vetoException) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)("Generation of file '" + fileName + "' on outlet '" + outletName + "' skipped due to veto."));
            }
        }
    }

    public String getNameString(ExecutionContext context) {
        return "FILE";
    }

    private Object getFilename(XpandExecutionContext ctx) {
        Object result = this.getTargetFileName().evaluate((ExecutionContext)ctx);
        if (result == null) {
            throw new EvaluationException("Nullevaluation", (SyntaxElement)this.getTargetFileName(), (ExecutionContext)ctx);
        }
        return result;
    }
}

