/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.openarchitectureware.compiler.runtime.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCallable
implements Callable {
    private final Method _mtd;
    private final Class<?>[] _paramTypes;

    public MethodCallable(Method mtd) {
        this._mtd = mtd;
        this._paramTypes = new Class[mtd.getParameterTypes().length + 1];
        this._paramTypes[0] = mtd.getDeclaringClass();
        System.arraycopy(mtd.getParameterTypes(), 0, this._paramTypes, 1, this._paramTypes.length - 1);
        int i = 0;
        while (i < mtd.getParameterTypes().length) {
            this._paramTypes[i + 1] = mtd.getParameterTypes()[i];
            ++i;
        }
    }

    @Override
    public String getName() {
        return this._mtd.getName();
    }

    @Override
    public Class<?>[] getParamTypes() {
        return this._paramTypes;
    }

    @Override
    public Object invoke(Object[] params) throws Throwable {
        Object[] actualParams = new Object[params.length - 1];
        System.arraycopy(params, 1, actualParams, 0, actualParams.length);
        return this.invoke(params[0], actualParams);
    }

    @Override
    public Object invoke(Object first, Object[] params) throws Throwable {
        if (first == null) {
            return null;
        }
        try {
            this._mtd.setAccessible(true);
            Object result = this._mtd.invoke(first, params);
            if (result != null && result.getClass().equals(Integer.class)) {
                return new Long(((Integer)result).intValue());
            }
            return result;
        }
        catch (InvocationTargetException exc) {
            throw exc.getCause();
        }
    }

    public String toString() {
        return "Method: " + this._mtd.getName() + "(" + Arrays.asList(this._paramTypes) + ")";
    }
}

