/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.compiler.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openarchitectureware.compiler.helpers.TemplateHelper;
import org.openarchitectureware.xpand2.ast.AbstractDefinition;
import org.openarchitectureware.xpand2.ast.ExpandStatement;
import org.openarchitectureware.xpand2.ast.ImportDeclaration;
import org.openarchitectureware.xpand2.ast.Statement;
import org.openarchitectureware.xpand2.ast.StatementWithBody;
import org.openarchitectureware.xpand2.ast.Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TemplateIncludesVisitor {
    private final Set<String> _result = new HashSet<String>();
    private final List<String> _importedNsWithSlash = new ArrayList<String>();
    private final Template _template;

    public TemplateIncludesVisitor(Template template) {
        this._template = template;
        Object[] objectArray = template.getImportedNamespaces();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ns = objectArray[n2];
            this._importedNsWithSlash.add(ns.replace("::", "/"));
            ++n2;
        }
        objectArray = template.getExtensions();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            String imp = objectArray[n2];
            this._result.add(((ImportDeclaration)((Object)imp)).getImportString().getValue().replace("::", "/"));
            ++n2;
        }
        objectArray = template.getAllDefinitions();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            String def = objectArray[n2];
            Statement[] statementArray = ((AbstractDefinition)((Object)def)).getBody();
            int n3 = statementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Statement stmt = statementArray[n4];
                this.visit(stmt);
                ++n4;
            }
            ++n2;
        }
    }

    public Set<String> getReferencedTemplateFqns() {
        return this._result;
    }

    private void visit(Statement stmt) {
        if (stmt instanceof ExpandStatement) {
            ExpandStatement expand = (ExpandStatement)stmt;
            String referenced = expand.getDefinition().getValue();
            if (!referenced.contains("::")) {
                return;
            }
            String templateName = referenced.substring(0, referenced.lastIndexOf("::"));
            String referencedFqn = TemplateHelper.getTemplateFqn(templateName, this._template);
            if (referencedFqn == null) {
                throw new RuntimeException("could not resolve template definition " + referenced + " in file " + this._template.getFileName() + " at line " + stmt.getLine());
            }
            this._result.add(referencedFqn);
        } else if (stmt instanceof StatementWithBody) {
            Statement[] statementArray = ((StatementWithBody)stmt).getBody();
            int n = statementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Statement substmt = statementArray[n2];
                this.visit(substmt);
                ++n2;
            }
        }
    }
}

