/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xtend.editor.scanning;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class KeywordRule
extends WordRule {
    private IToken keyWordToken;
    private static final IWordDetector WORDDETECTOR = new IWordDetector(){

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c);
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c);
        }
    };

    public KeywordRule(IToken token, String[] keywords) {
        super(WORDDETECTOR, Token.UNDEFINED);
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            this.addWord(keyword, token);
            ++n2;
        }
        this.keyWordToken = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        IToken result;
        int c = 32;
        if (scanner.getColumn() > 0) {
            scanner.unread();
            c = scanner.read();
        }
        if ((result = super.evaluate(scanner)) == this.keyWordToken) {
            return Character.isJavaIdentifierPart(c) || c == 94 ? Token.UNDEFINED : this.keyWordToken;
        }
        return result;
    }
}

