/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xtend.editor.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.editors.text.TextEditor;
import org.openarchitectureware.editor.AbstractOawEditor;
import org.openarchitectureware.editor.outlineview.AbstractOawContentOutlinePage;
import org.openarchitectureware.editor.outlineview.OutlineElement;
import org.openarchitectureware.expression.editor.EditorImages;
import org.openarchitectureware.xtend.ast.CreateExtensionStatement;
import org.openarchitectureware.xtend.ast.Extension;
import org.openarchitectureware.xtend.ast.ExtensionFile;
import org.openarchitectureware.xtend.core.IXtendResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendContentOutlinePage
extends AbstractOawContentOutlinePage {
    public static final int PRIVATE_CREATE_EXTENSION = 3;
    public static final int PRIVATE_EXTENSION = 4;
    public static final int CREATE_EXTENSION = 5;
    public static final int EXTENSION = 6;

    public XtendContentOutlinePage(AbstractOawEditor editor) {
        super((TextEditor)editor);
    }

    protected OutlineElement[] getChildren(Object parentElement) {
        if (parentElement instanceof IXtendResource) {
            ExtensionFile xr = (ExtensionFile)((IXtendResource)parentElement).getOawResource();
            if (xr == null) {
                return new OutlineElement[0];
            }
            ArrayList<OutlineElement> result = new ArrayList<OutlineElement>();
            result.addAll(this.toOutlineElementsForNamespaceImports(xr.getNsImports()));
            result.addAll(this.toOutlineElementsForExtensionImports(xr.getExtImports()));
            result.addAll(this.toOutlineElements(xr.getExtensions()));
            return result.toArray(new OutlineElement[result.size()]);
        }
        return new OutlineElement[0];
    }

    private List<OutlineElement> toOutlineElements(List<Extension> extensions) {
        ArrayList<OutlineElement> l = new ArrayList<OutlineElement>();
        for (Extension ext : extensions) {
            Image img = null;
            int type = 3;
            if (ext.isPrivate()) {
                if (ext instanceof CreateExtensionStatement) {
                    img = EditorImages.getImage((String)"extension_private_create.gif");
                } else {
                    img = EditorImages.getImage((String)"extension_private.gif");
                    type = 4;
                }
            } else if (ext instanceof CreateExtensionStatement) {
                img = EditorImages.getImage((String)"extension_create.gif");
                type = 5;
            } else {
                img = EditorImages.getImage((String)"extension.gif");
                type = 6;
            }
            l.add(new OutlineElement(ext.toOutlineString(), ext.getStart(), ext.getEnd() - ext.getStart(), img, type));
        }
        return l;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.registerToolbarActions(this.getSite().getActionBars());
    }

    private void registerToolbarActions(IActionBars actionBars) {
        actionBars.getToolBarManager().add((IAction)new AbstractOawContentOutlinePage.LexicalSortingAction((AbstractOawContentOutlinePage)this));
    }
}

