/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.xtend.editor.codeassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorPart;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.IOawResource;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.codeassist.ExpressionProposalComputer;
import org.openarchitectureware.expression.codeassist.ExtensionImportProposalComputer;
import org.openarchitectureware.expression.codeassist.ProposalFactory;
import org.openarchitectureware.expression.codeassist.TypeProposalComputer;
import org.openarchitectureware.expression.editor.codeassist.AbstractOawContentAssistProcessor;
import org.openarchitectureware.expression.editor.codeassist.ProposalComparator;
import org.openarchitectureware.expression.editor.codeassist.ProposalFactoryEclipseImpl;
import org.openarchitectureware.xpand2.codeassist.NamespaceProposalComputer;
import org.openarchitectureware.xtend.XtendFile;
import org.openarchitectureware.xtend.codeassist.FastAnalyzer;
import org.openarchitectureware.xtend.codeassist.Partition;
import org.openarchitectureware.xtend.core.IXtendResource;

public class XtendContentAssistProcessor
extends AbstractOawContentAssistProcessor
implements IContentAssistProcessor {
    public XtendContentAssistProcessor(IEditorPart editor) {
        super(editor);
    }

    protected ICompletionProposal[] internalComputeCompletionProposals(ITextViewer viewer, int documentOffset) {
        String part = viewer.getDocument().get().substring(0, documentOffset);
        ExecutionContext ctx = OawPlugin.getExecutionContext((IJavaProject)this.getJavaProject());
        IOawResource res = OawPlugin.getOawModelManager().findOawResource((IStorage)this.getFile());
        List extensions = new ArrayList();
        if (res instanceof IXtendResource) {
            extensions = ((IXtendResource)res).getExtensions();
        }
        Partition p = FastAnalyzer.computePartition((String)part);
        ProposalFactoryEclipseImpl factory = new ProposalFactoryEclipseImpl(documentOffset);
        List proposals = new ArrayList();
        if (p == Partition.EXPRESSION) {
            ctx = FastAnalyzer.computeExecutionContext((String)part, (ExecutionContext)ctx, extensions);
            int i = part.lastIndexOf(59);
            if (i != -1) {
                part = part.substring(i);
            }
            proposals = new ExpressionProposalComputer().computeProposals(part, ctx, (ProposalFactory)factory);
        } else if (p == Partition.TYPE_DECLARATION) {
            ctx = FastAnalyzer.computeExecutionContext((String)part, (ExecutionContext)ctx, extensions);
            proposals = new TypeProposalComputer().computeProposals(part, ctx, (ProposalFactory)factory);
        } else if (p == Partition.EXTENSION_IMPORT) {
            IOawProject project = OawPlugin.getOawModelManager().findProject((IResource)this.getFile());
            IOawResource[] resources = project.getAllRegisteredResources();
            HashSet<String> extensionNames = new HashSet<String>();
            IOawResource[] iOawResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IOawResource resource = iOawResourceArray[n2];
                if (resource instanceof XtendFile) {
                    extensionNames.add(resource.getFullyQualifiedName());
                }
                ++n2;
            }
            proposals = new ExtensionImportProposalComputer().computeProposals(part, ctx, (ProposalFactory)factory, extensionNames);
        } else if (p == Partition.NAMESPACE_IMPORT) {
            ctx = FastAnalyzer.computeExecutionContext((String)part, (ExecutionContext)ctx, extensions);
            proposals = new NamespaceProposalComputer().computeProposals(part, ctx, (ProposalFactory)factory);
        }
        Collections.sort(proposals, new ProposalComparator());
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

