/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.UnknownException;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.ServiceContext;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ObjectStub;
import org.openorb.CORBA.SystemExceptionHelper;
import org.openorb.PI.ClientManager;
import org.openorb.PI.RequestCallback;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.io.LocalOutputStream;
import org.openorb.net.AbstractClientRequest;
import org.openorb.net.Address;
import org.openorb.net.LocalServerRequest;
import org.openorb.net.RequestIDAllocator;
import org.openorb.net.ServerManager;
import org.openorb.util.Trace;

public class LocalClientRequest
extends AbstractClientRequest {
    private int m_request_id = 0;
    private Object m_target = null;
    private byte m_sync_scope = (byte)-1;
    private LocalServerRequest m_server_request = null;
    private InputStream m_reply_stream = null;
    private Address[] m_adresses;
    private ServerManager m_serverManager = null;
    private int m_reply_status;
    private ServiceContext[] m_reply_service_contexts;
    private boolean m_response_expected;
    private String m_operation;
    private ClientManager m_client_manager = null;
    private RequestCallback m_callback = null;
    private java.lang.Object m_sync_state = new java.lang.Object();
    private int m_state = 0;
    private OutputStream m_request_stream;
    private InputStream m_response_stream;
    private boolean m_response_arrived = false;
    private boolean m_last_response_arrived = false;
    private Object m_forward_reference = null;
    private IOR m_forward_reference_ior;
    private SystemException m_received_exception;
    private Any m_received_exception_any = null;
    private String m_received_exception_id;
    private static final short REPLY_STATUS_UNSET = Short.MIN_VALUE;

    public LocalClientRequest(org.omg.CORBA.ORB orb, int request_id, Object target, String operation, boolean response_expected, Address[] adresses) {
        super(request_id, target, adresses[0], target, null);
        this.m_request_id = request_id;
        this.m_adresses = adresses;
        this.m_operation = operation;
        this.m_target = target;
        this.m_response_expected = response_expected;
        this.m_serverManager = (ServerManager)((ORB)orb).getFeature("ServerCPCManager");
        this.m_request_stream = new LocalOutputStream();
        this.m_sync_scope = (byte)(this.m_response_expected ? 3 : 2);
        this.m_client_manager = (ClientManager)((ORB)this.orb()).getFeature("ClientInterceptorManager");
        if (this.m_client_manager != null) {
            this.m_callback = new LocalRequestCallback();
        }
    }

    public static LocalClientRequest createLocalClientRequest(org.omg.CORBA.ORB orb, Object target, String operation, boolean response_expected, Address[] adresses) {
        int request_id = RequestIDAllocator.get_request_id() << 1;
        LocalClientRequest lcr = new LocalClientRequest(orb, request_id, target, operation, response_expected, adresses);
        return lcr;
    }

    public int state() {
        return this.m_state;
    }

    public boolean is_request() {
        return this.m_operation != null;
    }

    public boolean is_locate() {
        return this.m_operation == null;
    }

    public boolean is_poll() {
        return false;
    }

    public short sync_scope() {
        return this.m_sync_scope;
    }

    public boolean response_expected() {
        return this.m_response_expected;
    }

    public String operation() {
        return this.m_operation == null ? "" : this.m_operation;
    }

    public boolean cancel(SystemException ex) {
        if (this.m_state == 4) {
            return false;
        }
        ex.completed = CompletionStatus.COMPLETED_YES;
        this.handle_system_exception(ex);
        return true;
    }

    public OutputStream begin_marshal() {
        return this.m_request_stream;
    }

    public int send_request() {
        InputStream is = this.m_request_stream.create_input_stream();
        byte[] object_id = this.m_adresses[0].getTargetAddress((short)0).object_key();
        ServiceContext[] request_service_contexts = this.get_request_service_contexts();
        this.m_server_request = new LocalServerRequest(this.m_serverManager, this.m_target, this.m_request_id, is, object_id, this.m_operation, this.m_sync_scope, request_service_contexts);
        this.m_server_request.begin_request();
        this.m_server_request.adapter(this.m_serverManager.find_adapter(object_id));
        try {
            this.m_server_request.dispatch();
        }
        catch (SystemException ex) {
            this.m_state = 4;
            ex.completed = CompletionStatus.COMPLETED_NO;
            this.handle_system_exception(ex);
            if (this.m_client_manager != null) {
                this.m_client_manager.receive_exception(this, this.m_callback);
                this.m_client_manager = null;
            }
            return this.m_state;
        }
        catch (AdapterDestroyedException ex) {
            Trace.signalIllegalCondition(this.getLogger(), "AdapterDestroyed on local object.");
        }
        this.m_reply_stream = this.m_server_request.getReplyStream().create_input_stream();
        if (this.m_server_request.is_reply_exception()) {
            this.m_received_exception_id = this.m_reply_stream.read_string();
            try {
                this.m_reply_stream.reset();
            }
            catch (IOException ioex) {
                // empty catch block
            }
        }
        this.m_state = 2;
        return this.m_state;
    }

    public boolean poll_response() {
        switch (this.m_state) {
            case 2: {
                return this.m_response_arrived;
            }
            case 0: 
            case 1: {
                throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
            }
            case 3: 
            case 4: {
                return true;
            }
        }
        Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
        return false;
    }

    public InputStream receive_response() {
        return this.m_server_request.getReplyStream().create_input_stream();
    }

    private void handle_system_exception(SystemException ex) {
        this.m_received_exception_any = null;
        this.m_received_exception = ex;
        this.m_received_exception_id = SystemExceptionHelper.id(ex);
        this.m_reply_status = 1;
    }

    private void handle_location_forward(Object forward, boolean permanent) {
        this.m_forward_reference = forward;
        this.m_forward_reference_ior = null;
        this.m_reply_status = 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int wait_for_response(long timeout) {
        var3_2 = this.m_sync_state;
        synchronized (var3_2) {
            switch (this.m_state) {
                case 2: {
                    break;
                }
                case 4: {
                    return this.m_state;
                }
                default: {
                    Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                }
            }
            this.m_response_arrived = false;
            switch (this.m_reply_status) {
                case 0: {
                    if (this.m_last_response_arrived) break;
                    this.m_state = 3;
                    return this.m_state;
                }
                case 2: {
                    this.m_response_stream.mark(0);
                    this.m_received_exception_id = this.m_response_stream.read_string();
                    try {
                        this.m_response_stream.reset();
                    }
                    catch (IOException ex) {
                        if (!this.getLogger().isErrorEnabled()) ** GOTO lbl27
                        this.getLogger().error("Error while resetting RequestStream.", ex);
                    }
lbl27:
                    // 3 sources

                    if (this.m_last_response_arrived) break;
                    this.m_state = 3;
                    return this.m_state;
                }
                case 1: {
                    this.m_received_exception_id = this.m_response_stream.read_string();
                    this.m_received_exception = SystemExceptionHelper.create(this.m_received_exception_id, "Server Exception", this.m_response_stream.read_ulong(), CompletionStatus.from_int(this.m_response_stream.read_ulong()));
                    this.m_received_exception_any = null;
                    break;
                }
                case 3: {
                    this.m_forward_reference_ior = IORHelper.read(this.m_response_stream);
                    this.m_forward_reference = null;
                }
                case -2: 
                case -1: 
                case 4: {
                    break;
                }
                default: {
                    Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                }
            }
            if (!this.m_last_response_arrived) {
                Trace.signalIllegalCondition(this.getLogger(), "Last response arrived.");
            }
            this.m_state = 3;
            this.lastReplyMessage();
            return this.m_state;
        }
    }

    private void lastReplyMessage() {
        SystemException ex = this.m_received_exception;
        boolean notify = false;
        this.m_last_response_arrived = true;
        if (this.m_state == 2) {
            if (ex == null) {
                return;
            }
            notify = true;
        }
        this.m_state = 4;
        if (ex != null) {
            this.handle_system_exception(ex);
        }
        if (this.m_client_manager != null) {
            switch (this.m_reply_status) {
                case 0: {
                    this.m_client_manager.receive_reply(this, this.m_callback);
                    break;
                }
                case 1: 
                case 2: {
                    this.m_client_manager.receive_exception(this, this.m_callback);
                    break;
                }
                case 3: 
                case 4: {
                    this.m_client_manager.receive_other(this, this.m_callback);
                    break;
                }
                case -2: 
                case -1: {
                    break;
                }
                default: {
                    Trace.signalIllegalCondition(this.getLogger(), "Invalid state of the state machine.");
                }
            }
        }
        this.m_response_arrived = true;
    }

    public short reply_status() {
        if (this.m_server_request.is_reply_exception()) {
            return 2;
        }
        return 0;
    }

    public ServiceContext get_reply_service_context(int id) {
        if (this.m_reply_service_contexts == null) {
            throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
        }
        switch (this.m_state) {
            case 3: 
            case 4: {
                int i = 0;
                while (i < this.m_reply_service_contexts.length) {
                    if (this.m_reply_service_contexts[i].context_id == id) {
                        return this.m_reply_service_contexts[i];
                    }
                    ++i;
                }
                throw new BAD_PARAM(1330446359, this.state_completion_status());
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public Object forward_reference() {
        switch (this.reply_status()) {
            case 3: {
                if (this.m_forward_reference == null) {
                    this.m_forward_reference = new ObjectStub(this.orb(), this.m_forward_reference_ior);
                }
                return this.m_forward_reference;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public IOR forward_reference_ior() {
        switch (this.reply_status()) {
            case 3: {
                if (this.m_forward_reference_ior == null) {
                    if (this.m_forward_reference == null || !(this.m_forward_reference instanceof ObjectImpl)) {
                        throw new INTERNAL("Forward object is unknown type");
                    }
                    Delegate deleg = ((ObjectImpl)this.m_forward_reference)._get_delegate();
                    if (deleg == null || !(deleg instanceof org.openorb.CORBA.Delegate)) {
                        throw new INTERNAL("Object delegate is unknown type");
                    }
                    this.m_forward_reference_ior = ((org.openorb.CORBA.Delegate)deleg).ior();
                }
                return this.m_forward_reference_ior;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemException received_system_exception() {
        java.lang.Object object = this.m_sync_state;
        synchronized (object) {
            if (this.reply_status() == 1) {
                return this.m_received_exception;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public Any received_exception() {
        switch (this.reply_status()) {
            case 1: {
                if (this.m_received_exception_any == null) {
                    this.m_received_exception_any = this.orb().create_any();
                    SystemExceptionHelper.insert(this.m_received_exception_any, this.m_received_exception);
                }
                return this.m_received_exception_any;
            }
            case 2: {
                throw new NO_RESOURCES(1330446337, this.state_completion_status());
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    public String received_exception_id() {
        switch (this.reply_status()) {
            case 1: 
            case 2: {
                return this.m_received_exception_id;
            }
        }
        throw new BAD_INV_ORDER(1330446346, this.state_completion_status());
    }

    protected void finalize() throws Throwable {
        this.cancel(new TIMEOUT());
    }

    private class LocalRequestCallback
    implements RequestCallback {
        private LocalRequestCallback() {
        }

        public void reply_system_exception(SystemException ex) {
            LocalClientRequest.this.handle_system_exception(ex);
        }

        public void reply_location_forward(Object forward, boolean permanent) {
            LocalClientRequest.this.handle_location_forward(forward, permanent);
        }

        public void reply_runtime_exception(RuntimeException ex) {
            UnknownException uex = new UnknownException(ex);
            uex.completed = LocalClientRequest.this.state_completion_status();
            LocalClientRequest.this.handle_system_exception(uex);
        }

        public void reply_error(Error ex) {
            if (ex instanceof ThreadDeath) {
                throw ex;
            }
            if (ex instanceof OutOfMemoryError) {
                LocalClientRequest.this.handle_system_exception(new NO_MEMORY());
            } else if (ex instanceof StackOverflowError) {
                LocalClientRequest.this.handle_system_exception(new NO_RESOURCES("Stack Overflow", 1146056983, LocalClientRequest.this.state_completion_status()));
            } else {
                UnknownException uex = new UnknownException(ex);
                uex.completed = LocalClientRequest.this.state_completion_status();
                LocalClientRequest.this.handle_system_exception(uex);
            }
        }
    }
}

