/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.messaging;

import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.Messaging.SyncScopeHelper;
import org.omg.Messaging.SyncScopePolicy;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.TimeBase.TimeTHelper;
import org.omg.TimeBase.UtcTHelper;

class PolicyFactoryImpl
extends LocalObject
implements PolicyFactory {
    private static PolicyFactoryImpl s_instance = null;
    private static SyncScopePolicyImpl[] s_pol_sync_scope = null;
    private static RelativeRoundtripTimeoutPolicyImpl[] s_pol_rel_rt_timeout = null;

    private PolicyFactoryImpl() {
    }

    static PolicyFactoryImpl getInstance() {
        if (s_instance == null) {
            s_instance = new PolicyFactoryImpl();
        }
        return s_instance;
    }

    public Policy create_policy(int type, Any value) throws PolicyError {
        switch (type) {
            case 24: {
                if (!value.type().equal(SyncScopeHelper.type())) {
                    throw new PolicyError(2);
                }
                return new SyncScopePolicyImpl(SyncScopeHelper.extract(value));
            }
            case 31: {
                if (!value.type().equal(TimeTHelper.type())) {
                    throw new PolicyError(2);
                }
                throw new NO_IMPLEMENT();
            }
            case 32: {
                if (!value.type().equal(TimeTHelper.type())) {
                    throw new PolicyError(2);
                }
                return new RelativeRoundtripTimeoutPolicyImpl(TimeTHelper.extract(value));
            }
            case 30: {
                if (!value.type().equal(UtcTHelper.type())) {
                    throw new PolicyError(2);
                }
            }
            case 29: {
                if (!value.type().equal(UtcTHelper.type())) {
                    throw new PolicyError(2);
                }
            }
            case 28: {
                if (!value.type().equal(UtcTHelper.type())) {
                    throw new PolicyError(2);
                }
            }
            case 27: {
                if (!value.type().equal(UtcTHelper.type())) {
                    throw new PolicyError(2);
                }
                throw new NO_IMPLEMENT();
            }
        }
        throw new PolicyError(0);
    }

    private static class RelativeRoundtripTimeoutPolicyImpl
    extends LocalObject
    implements RelativeRoundtripTimeoutPolicy {
        private long m_relative_expiry;

        RelativeRoundtripTimeoutPolicyImpl(long val) {
            this.m_relative_expiry = val;
        }

        public long relative_expiry() {
            return this.m_relative_expiry;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 32;
        }
    }

    private static class SyncScopePolicyImpl
    extends LocalObject
    implements SyncScopePolicy {
        private short m_sync_scope;

        SyncScopePolicyImpl(short val) {
            this.m_sync_scope = val;
        }

        public short synchronization() {
            return this.m_sync_scope;
        }

        public void destroy() {
        }

        public Policy copy() {
            return this;
        }

        public int policy_type() {
            return 24;
        }
    }
}

