/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.util.stdlib;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openarchitectureware.util.stdlib.DynamicEcoreHelper;
import org.openarchitectureware.workflow.issues.Issues;

public class DanglingRefFinder {
    private Set<EObject> set = new HashSet<EObject>();

    public void handle(EObject o, Issues issues) {
        if (this.set.contains(o) || this.shouldIgnore(o)) {
            return;
        }
        this.set.add(o);
        EObject cont = o.eContainer();
        if (cont != null) {
            this.handle(cont, issues);
        }
        EList refs = o.eClass().getEAllReferences();
        for (EReference reference : refs) {
            if (reference.isMany()) {
                Collection col = (Collection)o.eGet((EStructuralFeature)reference);
                for (EObject object : col) {
                    this.checkNullRef(o, reference, object, issues);
                    if (object == null) continue;
                    this.checkDangling(o, reference, object, issues);
                    this.handle(object, issues);
                }
                continue;
            }
            EObject object = (EObject)o.eGet((EStructuralFeature)reference);
            if (object == null) continue;
            this.checkDangling(o, reference, object, issues);
            this.handle(object, issues);
        }
    }

    private boolean shouldIgnore(EObject o) {
        boolean b = o instanceof EFactory;
        return b;
    }

    private void checkNullRef(EObject ctx, EReference reference, EObject target, Issues issues) {
        if (target == null) {
            issues.addWarning(String.valueOf(this.renderEObject(ctx)) + "." + this.renderEReference(reference) + ": contains a null object");
        }
    }

    private void checkDangling(EObject ctx, EReference reference, EObject target, Issues issues) {
        if (this.shouldIgnore(target)) {
            return;
        }
        if (target.eContainer() == null && target.eResource() == null) {
            issues.addWarning(String.valueOf(this.renderEObject(target)) + " is not contained in an eContainer or Resource. Found in " + this.renderEObject(ctx) + "." + this.renderEReference(reference));
        }
    }

    private String renderEObject(EObject ctx) {
        DynamicEcoreHelper h = new DynamicEcoreHelper(ctx);
        return String.valueOf(h.getName(ctx)) + "(" + ctx.eClass().getName() + ")";
    }

    private String renderEReference(EReference ctx) {
        return String.valueOf(ctx.getName()) + " [" + (ctx.isContainer() ? "container=true" : "container=false") + "]";
    }
}

