/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.util.stdlib;

import java.util.HashMap;
import java.util.Map;

public class CounterExtensions {
    private static int globalCounter = 0;
    private static Map<Object, Integer> vars = new HashMap<Object, Integer>();

    public static int counterReset(Object o) {
        if (o == null) {
            globalCounter = 0;
        }
        vars.put(o, new Integer(0));
        return 0;
    }

    public static int counterInc(Object o) {
        if (o == null) {
            return globalCounter++;
        }
        Integer count = vars.get(o);
        if (count == null) {
            count = new Integer(0);
        }
        int i = count + 1;
        vars.put(o, new Integer(i));
        return i;
    }

    public static int counterDec(Object o) {
        if (o == null) {
            return globalCounter--;
        }
        Integer count = vars.get(o);
        if (count == null) {
            count = new Integer(0);
        }
        int i = count - 1;
        vars.put(o, new Integer(i));
        return i;
    }

    public static int counterGet(Object o) {
        if (o == null) {
            return globalCounter++;
        }
        Integer count = vars.get(o);
        if (count == null) {
            count = new Integer(0);
        }
        return count;
    }
}

