/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.adapter.emf.check;

import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openarchitectureware.workflow.issues.Issue;
import org.openarchitectureware.workflow.issues.Issues;

public class IssuesDiagnosticAdapter {
    public static final void addDiagnosticFromIssues(DiagnosticChain allDiagnostics, Issues issues) {
        Issue[] errors = issues.getErrors();
        IssuesDiagnosticAdapter.addDiagnostics(allDiagnostics, 4, errors);
        Issue[] warnings = issues.getWarnings();
        IssuesDiagnosticAdapter.addDiagnostics(allDiagnostics, 2, warnings);
    }

    private static void addDiagnostics(DiagnosticChain allDiagnostics, int severity, Issue[] errors) {
        Issue[] issueArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            Issue issue = issueArray[n2];
            Object element = issue.getElement();
            String message = issue.getMessage();
            Object[] objectArray = new Object[2];
            objectArray[0] = element;
            Object[] objects = objectArray;
            String cleanedMessage = IssuesDiagnosticAdapter.extractFeatureFromMessageAndStoreIt(message, objects);
            if (cleanedMessage != null) {
                message = cleanedMessage;
            }
            BasicDiagnostic diagnostic = new BasicDiagnostic(severity, "Oaw Check", 0, message, objects);
            allDiagnostics.add((Diagnostic)diagnostic);
            ++n2;
        }
    }

    private static String extractFeatureFromMessageAndStoreIt(String message, Object[] store) {
        Object o;
        int i = message.indexOf(35);
        if (i > 0 && i < message.length() - 1 && (o = store[0]) != null && o instanceof EObject) {
            EObject eObject = (EObject)o;
            String featureName = message.substring(0, i);
            message = message.substring(i + 1);
            EStructuralFeature feature = eObject.eClass().getEStructuralFeature(featureName);
            if (feature != null) {
                store[1] = feature;
                return message;
            }
        }
        return null;
    }
}

