/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.emf;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.openarchitectureware.emf.Setup;
import org.openarchitectureware.workflow.ConfigurationException;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;
import org.openarchitectureware.workflow.util.ResourceLoaderFactory;

@Deprecated
public class XmiReader
extends AbstractWorkflowComponent {
    private static final String COMPONENT_NAME = "XMI Reader";
    protected String modelFile;
    protected String outputSlot = "default";
    protected boolean firstElementOnly = true;

    public String getLogMessage() {
        return "file '" + this.modelFile + "' => slot '" + this.outputSlot + "'";
    }

    public void setMetaModelFile(String metaModelFile) {
        new Setup().addEPackageFile(metaModelFile);
    }

    public void setMetaModelPackage(String metaModelPackage) {
        new Setup().addEPackageClass(metaModelPackage);
    }

    public void setMetaModelDescriptor(String metaModelDescriptor) {
        new Setup().addEPackageDescriptor(metaModelDescriptor);
    }

    public void setModelFile(String modelFile) {
        this.modelFile = modelFile;
    }

    public void setOutputSlot(String outputSlot) {
        this.outputSlot = outputSlot;
    }

    public void setFirstElementOnly(boolean firstElementOnly) {
        this.firstElementOnly = firstElementOnly;
    }

    public void checkConfiguration(Issues issues) {
        this.loadFile(issues);
    }

    public void invoke(WorkflowContext model, ProgressMonitor monitor, Issues issues) {
        File f = this.loadFile(issues);
        URI fileURI = URI.createFileURI((String)f.getAbsolutePath());
        Resource r = new ResourceSetImpl().createResource(fileURI);
        try {
            r.load(null);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
        if (this.firstElementOnly) {
            model.set(this.outputSlot, r.getContents().get(0));
        } else {
            model.set(this.outputSlot, (Object)r.getContents());
        }
    }

    protected File loadFile(Issues issues) {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        if (this.modelFile == null) {
            issues.addError("No modelFile specified!");
            return null;
        }
        URL url = ResourceLoaderFactory.createResourceLoader().getResource(this.modelFile);
        if (url == null || url.getFile() == null) {
            issues.addError((WorkflowComponent)this, "cannot find file: " + this.modelFile);
            return null;
        }
        File f = new File(URI.decode((String)url.getFile()));
        if (!f.exists()) {
            issues.addError((WorkflowComponent)this, "cannot find file: " + this.modelFile);
            return null;
        }
        return f;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

