/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class LaunchView
extends ViewPart {
    private static LaunchView instance = null;
    private org.eclipse.swt.widgets.List list;
    private List<LaunchInfo> data = null;

    public static LaunchView currentInstance() {
        return instance;
    }

    public void createPartControl(Composite parent) {
        instance = this;
        this.list = new org.eclipse.swt.widgets.List(parent, 768);
        Action runAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"run.gif");
            }

            public void run() {
                LaunchView.this.runSelection();
            }
        };
        Action clearAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"clear.gif");
            }

            public void run() {
                LaunchView.this.list.removeAll();
                LaunchView.this.list.update();
                LaunchView.this.data.clear();
            }
        };
        Action removeAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"remove.gif");
            }

            public void run() {
                int current = LaunchView.this.list.getSelectionIndex();
                if (current >= 0) {
                    LaunchView.this.list.remove(current);
                    LaunchView.this.list.update();
                    LaunchView.this.data.remove(current);
                }
            }
        };
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager mgr = bars.getToolBarManager();
        mgr.add((IAction)runAction);
        mgr.add((IAction)removeAction);
        mgr.add((IAction)clearAction);
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                LaunchView.this.runSelection();
            }
        });
        this.data = new ArrayList<LaunchInfo>();
    }

    private void runSelection() {
        int current = this.list.getSelectionIndex();
        if (current >= 0) {
            LaunchInfo info = this.data.get(current);
            DebugUITools.launch((ILaunchConfiguration)info.config, (String)info.mode);
        }
    }

    public static void addConfiguration(ILaunchConfiguration config, String mode, IFile file) {
        if (instance == null) {
            return;
        }
        instance.addConfigurationInternal(config, mode, file);
    }

    public void addConfigurationInternal(ILaunchConfiguration config, String mode, IFile file) {
        if (!this.data.contains(config)) {
            LaunchInfo info = new LaunchInfo(config, mode, file);
            this.data.add(info);
            this.list.add(this.makeNiceString(info));
            this.list.update();
        }
    }

    private String makeNiceString(LaunchInfo info) {
        String name = info.file.getName();
        String project = info.file.getFullPath().segment(0);
        String str = String.valueOf(name) + " - " + project;
        return str;
    }

    public void setFocus() {
    }

    class LaunchInfo {
        public ILaunchConfiguration config;
        public String mode;
        public IFile file;

        public LaunchInfo(ILaunchConfiguration config, String mode, IFile file) {
            this.config = config;
            this.mode = mode;
            this.file = file;
        }
    }
}

