/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.debug;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.openarchitectureware.debug.model.OawBreakpoint;
import org.openarchitectureware.debug.processing.IPluginAdapter;
import org.openarchitectureware.workflow.Activator;
import org.openarchitectureware.workflow.ast.AbstractASTBase;
import org.openarchitectureware.workflow.ast.ComponentAST;
import org.openarchitectureware.workflow.ast.InclusionAST;
import org.openarchitectureware.workflow.ast.parser.Location;
import org.openarchitectureware.workflow.ast.parser.XmlLocationAnalyser;
import org.openarchitectureware.workflow.ast.util.WorkflowFactory;
import org.openarchitectureware.workflow.editors.WorkflowEditor;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.issues.IssuesImpl;
import org.openarchitectureware.workflow.util.PluginConfigurationElementUtil;
import org.osgi.framework.Bundle;

public class WorkflowPluginAdapter
implements IPluginAdapter {
    private XmlLocationAnalyser locationAnalyser = new XmlLocationAnalyser();
    private Image icon = null;

    public boolean canHandleResourceExtension(String ext) {
        return this.getRequiredExtension().equals(ext);
    }

    public boolean canHandleType(String type) {
        return "workflow".equals(type);
    }

    public String getRequiredExtension() {
        return "oaw";
    }

    public String getEditorId() {
        return PluginConfigurationElementUtil.getConfigAttribute("org.eclipse.ui.editors/editor[class=" + WorkflowEditor.class.getName() + "]/id");
    }

    public boolean isToggleBpEnabled(IResource resource, int start, int end, int line) {
        return this.getComponentAstAtLine(resource, line) != null;
    }

    public OawBreakpoint createBreakpoint(IResource resource, int start, int end, int line) throws CoreException {
        ComponentAST comp = this.getComponentAstAtLine(resource, line);
        if (comp == null) {
            return null;
        }
        return new OawBreakpoint(resource, this.getElementName(comp), comp.getLineNumber(), comp.getOffset(), comp.getLength());
    }

    public IBreakpoint checkBreakpoints(IBreakpoint[] bps, IResource resource, int start, int end, int line) throws CoreException {
        ComponentAST comp = this.getComponentAstAtLine(resource, line);
        if (comp == null) {
            return null;
        }
        Location loc = this.locationAnalyser.adapt(comp.getLocation());
        IBreakpoint[] iBreakpointArray = bps;
        int n = bps.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp1 = iBreakpointArray[n2];
            OawBreakpoint bp = (OawBreakpoint)bp1;
            if (bp.getResource().equals(resource.getFullPath().toString()) && bp.getLine() == loc.getLineNumber() && bp.getCharStart() == loc.getNameStart() && bp.getCharEnd() == loc.getNameEnd()) {
                return bp;
            }
            ++n2;
        }
        return null;
    }

    private ComponentAST getComponentAstAtLine(IResource resource, int lineNumber) {
        HashMap params;
        IssuesImpl issues;
        IPath path = resource.getFullPath();
        WorkflowFactory factory = new WorkflowFactory();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        String wfFileName = file.getLocation().toString();
        AbstractASTBase wfAST = factory.parseAndInitialize(wfFileName, (Issues)(issues = new IssuesImpl()), params = new HashMap());
        if (wfAST != null && wfAST instanceof ComponentAST) {
            List candidates = ((ComponentAST)wfAST).getChildren();
            AbstractASTBase candidate = null;
            Location loc = null;
            for (AbstractASTBase next : candidates) {
                loc = this.locationAnalyser.adapt(next.getLocation());
                next.setLocation(loc);
                if (loc.getLineNumber() > lineNumber && candidate instanceof ComponentAST) {
                    return (ComponentAST)candidate;
                }
                candidate = next;
            }
            if (candidate instanceof ComponentAST) {
                return (ComponentAST)candidate;
            }
        }
        return null;
    }

    private String getElementName(ComponentAST ast) {
        if (ast.getId() != null) {
            return ast.getId();
        }
        if (ast instanceof InclusionAST) {
            return ((InclusionAST)ast).getFile();
        }
        String clazz = new Path(ast.getClazz()).getFileExtension();
        if (clazz != null) {
            return clazz;
        }
        return ast.getClazz();
    }

    public Image getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        Path path = new Path("/icons/workflowfile.gif");
        InputStream is = null;
        try {
            is = FileLocator.openStream((Bundle)Activator.getDefault().getBundle(), (IPath)path, (boolean)false);
        }
        catch (IOException iOException) {}
        if (is != null) {
            ImageData iData = new ImageData(is);
            this.icon = new Image((Device)Display.getCurrent(), iData);
            return this.icon;
        }
        return null;
    }
}

