/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.processing.handlers;

import java.io.IOException;
import org.eclipse.debug.core.DebugException;
import org.openarchitectureware.debug.communication.Connection;
import org.openarchitectureware.debug.communication.packets.AbstractPacket;
import org.openarchitectureware.debug.communication.packets.ConfirmationPacket;
import org.openarchitectureware.debug.communication.packets.EventPacket;
import org.openarchitectureware.debug.communication.packets.EventPacketWithFrames;
import org.openarchitectureware.debug.processing.DebugModelManager;
import org.openarchitectureware.workflow.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventPluginHandler
implements Runnable {
    private Connection connection;
    private DebugModelManager dmm;
    private Class<? extends AbstractPacket> typeToListen = EventPacket.class;

    public void setDmm(DebugModelManager dmm) {
        this.dmm = dmm;
    }

    public Class<? extends AbstractPacket> getPacketType() {
        return this.typeToListen;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void startListener() {
        Thread thread = new Thread((Runnable)this, this.getClass().getSimpleName());
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.dispatch((EventPacket)this.connection.listenForPacket(this.typeToListen));
            }
        }
        catch (Exception exception) {
            this.connection.close();
            return;
        }
    }

    private void dispatch(EventPacket packet) throws DebugException {
        this.dmm.getThread().setBreakpoint(null);
        switch (packet.event) {
            case 1: {
                this.dmm.debuggerStarted();
                break;
            }
            case 2: {
                this.adaptStackFrames(packet);
                this.dmm.debuggerSuspended();
                break;
            }
            case 3: {
                this.dmm.debuggerResumed();
                break;
            }
            case 4: {
                this.dmm.debuggerTerminated();
                break;
            }
            default: {
                Activator.logError("Internal error.\nInvalid event received: " + packet.event, null);
                return;
            }
        }
        ConfirmationPacket conf = new ConfirmationPacket(packet.getId());
        try {
            this.connection.sendPacket((AbstractPacket)conf);
        }
        catch (IOException e) {
            throw new DebugException(Activator.createErrorStatus("lost connection to debugger runtime process --> aborting", e));
        }
    }

    private void adaptStackFrames(EventPacket sp) {
        EventPacketWithFrames packet = (EventPacketWithFrames)sp;
        this.dmm.adaptStackFrames(packet.cleanStackLevel, packet.frames);
    }
}

