/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.processing.handlers;

import java.io.IOException;
import org.eclipse.debug.core.DebugException;
import org.openarchitectureware.debug.communication.Connection;
import org.openarchitectureware.debug.communication.packets.AbstractPacket;
import org.openarchitectureware.debug.communication.packets.CommandPacket;
import org.openarchitectureware.workflow.Activator;

public class CommandPluginHandler {
    private Connection connection;

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void sendStepIntoCommand() throws DebugException {
        this.sendCommand(1);
    }

    public void sendStepOverCommand() throws DebugException {
        this.sendCommand(2);
    }

    public void sendStepReturnCommand() throws DebugException {
        this.sendCommand(3);
    }

    public void sendResumeCommand() throws DebugException {
        this.sendCommand(4);
    }

    public void sendSuspendCommand() throws DebugException {
        this.sendCommand(5);
    }

    public void sendTerminateCommand() throws DebugException {
        this.sendCommand(6);
    }

    private void sendCommand(int type) throws DebugException {
        try {
            this.connection.sendPacket((AbstractPacket)new CommandPacket(type));
        }
        catch (IOException e) {
            throw new DebugException(Activator.createErrorStatus("lost connection to debugger runtime process", e));
        }
    }
}

