/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.model.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.openarchitectureware.debug.model.DebugStackFrame;
import org.openarchitectureware.debug.model.DebugValue;
import org.openarchitectureware.debug.model.OawBreakpoint;
import org.openarchitectureware.debug.model.ui.JarEntryEditorInput;
import org.openarchitectureware.debug.processing.IPluginAdapter;
import org.openarchitectureware.debug.processing.PluginExtensionManager;

public class DebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        if (element instanceof DebugStackFrame) {
            DebugStackFrame frame = (DebugStackFrame)((Object)element);
            IPluginAdapter adapter = PluginExtensionManager.getDefault().getAdapterByType(frame.getType());
            if (adapter != null) {
                return adapter.getIcon();
            }
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof OawBreakpoint) {
            return ((OawBreakpoint)((Object)element)).getName();
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String detail = ((DebugValue)value).getDetailRep();
        listener.detailComputed(value, detail);
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof ILineBreakpoint) {
            return new FileEditorInput((IFile)((ILineBreakpoint)element).getMarker().getResource());
        }
        if (element instanceof IStorage) {
            return new JarEntryEditorInput((IStorage)element);
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        String ext = "";
        if ((element instanceof IFile || element instanceof ILineBreakpoint) && input instanceof IFileEditorInput) {
            ext = ((IFileEditorInput)input).getFile().getFileExtension();
        } else if (element instanceof IStorage && input instanceof JarEntryEditorInput) {
            ext = ((JarEntryEditorInput)input).getContentType();
        }
        IPluginAdapter adapter = PluginExtensionManager.getDefault().getAdapterByResourceExtension(ext);
        if (adapter != null) {
            return adapter.getEditorId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }
}

