/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.util;

import org.openarchitectureware.workflow.util.ResourceLoader;
import org.openarchitectureware.workflow.util.ResourceLoaderDefaultImpl;

public class ResourceLoaderFactory {
    public static final String PARAM_RESOURCELOADER_CLASS = "org.openarchitectureware.resourceimpl";
    private static Class<?> resourceLoaderImpl;
    private static final ThreadLocal<ResourceLoader> current;

    static {
        current = new ThreadLocal();
    }

    public static void setCurrentThreadResourceLoader(ResourceLoader rl) {
        current.set(rl);
    }

    private static void initResourceLoaderClass() {
        String name = System.getProperty(PARAM_RESOURCELOADER_CLASS, ResourceLoaderDefaultImpl.class.getName());
        if (resourceLoaderImpl == null || name != null && !name.equals(resourceLoaderImpl.getName())) {
            try {
                resourceLoaderImpl = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ResourceLoader createResourceLoader() throws RuntimeException {
        if (current.get() != null) {
            return current.get();
        }
        ResourceLoaderFactory.initResourceLoaderClass();
        try {
            return (ResourceLoader)resourceLoaderImpl.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

