/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.openarchitectureware.workflow.util.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoaderDefaultImpl
implements ResourceLoader {
    private static final String FILE_PREFIX = "file:";

    @Override
    public final InputStream getResourceAsStream(String path) {
        InputStream in = this.internalGetResourceAsStream(path);
        if (in == null) {
            try {
                return new URIConverterImpl().createInputStream(URI.createURI((String)path));
            }
            catch (Exception exception) {
                try {
                    in = new FileInputStream(path);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!path.startsWith(FILE_PREFIX)) {
                        path = FILE_PREFIX + path;
                    }
                    try {
                        in = new FileInputStream(path);
                    }
                    catch (Exception exception2) {
                        return null;
                    }
                }
            }
        }
        return in;
    }

    protected InputStream internalGetResourceAsStream(String path) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
    }

    @Override
    public final Class<?> loadClass(String clazzName) {
        try {
            return this.internalLoadClass(clazzName);
        }
        catch (Exception exception) {
            if (clazzName.startsWith("oaw")) {
                return this.loadClass(clazzName.replaceFirst("oaw", "org.openarchitectureware"));
            }
            return null;
        }
    }

    protected Class<?> internalLoadClass(String clazzName) throws ClassNotFoundException {
        return Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public final URL getResource(String path) {
        URL url = this.internalGetResource(path);
        if (url == null) {
            try {
                File file = new File(path);
                if (file.exists()) {
                    return file.getAbsoluteFile().toURL();
                }
                if (!path.startsWith(FILE_PREFIX)) {
                    path = FILE_PREFIX + path;
                }
                if ((url = new URL(path)).getContent() == null) {
                    return null;
                }
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return url;
    }

    protected URL internalGetResource(String path) {
        return Thread.currentThread().getContextClassLoader().getResource(path);
    }
}

