/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.issues.indexed;

import java.util.Set;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.issues.Issue;
import org.openarchitectureware.workflow.issues.IssuesImpl;
import org.openarchitectureware.workflow.issues.indexed.IndexedIssues;
import org.openarchitectureware.workflow.issues.indexed.MapSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedIssuesImpl
extends IssuesImpl
implements IndexedIssues {
    private final MapSet<Object, Issue> indexedErrors = new MapSet();
    private final MapSet<Object, Issue> indexedWarnings = new MapSet();

    @Override
    public void addError(WorkflowComponent ctx, String msg, Object element) {
        super.addError(ctx, msg, element);
        this.indexedErrors.put(element, new Issue(ctx, msg, element));
    }

    @Override
    public void addWarning(WorkflowComponent ctx, String msg, Object element) {
        super.addWarning(ctx, msg, element);
        this.indexedWarnings.put(element, new Issue(ctx, msg, element));
    }

    @Override
    public void addError(String msg, Object element) {
        super.addError(msg, element);
        this.indexedErrors.put(element, new Issue(msg, element));
    }

    @Override
    public void addWarning(String msg, Object element) {
        super.addWarning(msg, element);
        this.indexedWarnings.put(element, new Issue(msg, element));
    }

    @Override
    public Set<Issue> getErrorsFor(Object element) {
        return this.indexedErrors.get(element);
    }

    @Override
    public Set<Issue> getWarningsFor(Object element) {
        return this.indexedWarnings.get(element);
    }

    @Override
    public void cleanFor(Object element) {
        this.indexedWarnings.remove(element);
        this.indexedErrors.remove(element);
    }
}

