/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.issues;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowComponentWithID;
import org.openarchitectureware.workflow.util.ComponentPrinter;

public class Issue {
    private WorkflowComponent context;
    private Object element;
    private String message;

    public Issue(WorkflowComponent ctx, String msg, Object element) {
        this.context = ctx;
        this.message = msg;
        this.element = element;
    }

    public Issue(String msg, Object element) {
        this.message = msg;
        this.element = element;
    }

    public Object getElement() {
        return this.element;
    }

    public WorkflowComponent getContext() {
        return this.context;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        if (this.context != null) {
            WorkflowComponentWithID wfcId;
            bf.append("ERROR in Component ");
            if (this.context instanceof WorkflowComponentWithID && (wfcId = (WorkflowComponentWithID)this.context).getId() != null) {
                bf.append(wfcId.getId()).append(" ");
            }
            bf.append("of type ").append(this.context.getClass().getName()).append("\n\t");
        }
        bf.append(this.getMessage());
        if (this.getElement() != null) {
            if (this.getElement() instanceof Throwable) {
                Throwable t = (Throwable)this.getElement();
                StringWriter stringWriter = new StringWriter();
                t.printStackTrace(new PrintWriter(stringWriter));
                bf.append("[" + stringWriter.toString() + "]");
            } else {
                bf.append(" [" + this.getElement().toString() + "] ");
            }
        }
        if (this.getContext() != null) {
            bf.append(" in workflow: " + ComponentPrinter.getString(this.getContext()));
        }
        return bf.toString();
    }
}

