/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.debug;

import java.util.ArrayList;
import java.util.List;
import org.openarchitectureware.debug.model.NameValuePair;
import org.openarchitectureware.debug.model.SyntaxElementTO;
import org.openarchitectureware.debug.processing.IElementAdapter;
import org.openarchitectureware.workflow.WorkflowComponent;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.ast.parser.Location;
import org.openarchitectureware.workflow.ast.parser.XmlLocationAnalyser;
import org.openarchitectureware.workflow.container.CompositeComponent;
import org.openarchitectureware.workflow.util.ComponentPrinter;
import org.openarchitectureware.workflow.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowElementAdapter
implements IElementAdapter {
    protected static final String TYPE = "workflow";
    private Object context;
    private CompositeComponent root;
    private XmlLocationAnalyser locationAnalyser = new XmlLocationAnalyser();

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }

    @Override
    public String getAdapterType() {
        return TYPE;
    }

    @Override
    public boolean canHandle(Object element) {
        if (element instanceof WorkflowComponent) {
            if (this.root == null) {
                this.root = ((WorkflowComponent)element).getContainer();
            }
            return true;
        }
        if (element instanceof SyntaxElementTO) {
            SyntaxElementTO se = (SyntaxElementTO)element;
            return se.resource.endsWith(".oaw");
        }
        return false;
    }

    @Override
    public boolean shallHandle(Object element) {
        return true;
    }

    @Override
    public boolean shallSuspend(Object element, int flag) {
        return true;
    }

    @Override
    public boolean isSurroundingElement(Object element) {
        return CompositeComponent.class.isAssignableFrom(element.getClass());
    }

    @Override
    public SyntaxElementTO createElementTO(Object element) {
        WorkflowComponent comp = (WorkflowComponent)element;
        SyntaxElementTO se = new SyntaxElementTO();
        Location loc = comp.getLocation();
        loc = this.initialize(loc);
        se.containerName = ComponentPrinter.getContainerName(comp);
        se.elementName = ComponentPrinter.getElementName(comp);
        se.resource = loc.getResource();
        se.start = loc.getNameStart();
        se.end = loc.getNameEnd();
        se.line = loc.getLineNumber();
        return se;
    }

    @Override
    public SyntaxElementTO createEndElementTO(Object element) {
        CompositeComponent comp = (CompositeComponent)element;
        SyntaxElementTO se = new SyntaxElementTO();
        Location loc = comp.getOwnLocation();
        if (loc == null) {
            loc = comp.getLocation();
        }
        loc = this.initializeEndLocation(loc);
        se.containerName = ComponentPrinter.getElementName(comp);
        se.elementName = "end of cartridge";
        if (loc != null) {
            se.resource = loc.getResource();
            se.start = loc.getNameStart();
            se.end = loc.getNameEnd();
            se.line = loc.getLineNumber();
        }
        return se;
    }

    @Override
    public List<NameValuePair> getVariables(Object element) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        if (element instanceof WorkflowComponent) {
            WorkflowContext ctx = (WorkflowContext)this.context;
            String[] stringArray = ctx.getSlotNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                list.add(new NameValuePair(name, ctx.get(name)));
                ++n2;
            }
        } else {
            int i = 0;
            for (String name : ReflectionUtil.getFieldNames(element)) {
                Object childElement = element instanceof Object[] ? ((Object[])element)[i++] : ReflectionUtil.getFieldValue(element, name);
                list.add(new NameValuePair(name, childElement));
            }
        }
        return list;
    }

    @Override
    public String getVariableDetailRep(Object element) {
        return ReflectionUtil.getNameToString(element);
    }

    @Override
    public String getVariableSimpleRep(Object element) {
        return ReflectionUtil.getSimpleName(element);
    }

    @Override
    public boolean checkVariableHasMembers(Object element) {
        return ReflectionUtil.checkFields(element);
    }

    @Override
    public Object findElement(SyntaxElementTO se, Object actual, int flag) {
        if (this.root == null) {
            return null;
        }
        return this.findComponent(this.root, se.resource, se.line);
    }

    private Object findComponent(CompositeComponent parent, String resource, int lineNo) {
        Location loc = parent.getOwnLocation();
        if (loc == null) {
            loc = parent.getLocation();
        }
        if (resource.endsWith(loc.getResource())) {
            for (WorkflowComponent comp : parent.getComponents()) {
                if (comp.getLocation().getLineNumber() != lineNo) continue;
                return comp;
            }
        }
        for (WorkflowComponent comp : parent.getComponents()) {
            CompositeComponent child;
            Object found;
            if (!(comp instanceof CompositeComponent) || (found = this.findComponent(child = (CompositeComponent)comp, resource, lineNo)) == null) continue;
            return found;
        }
        return null;
    }

    private Location initialize(Location loc) {
        if (loc.getResource() == null) {
            return null;
        }
        return this.locationAnalyser.adapt(loc);
    }

    private Location initializeEndLocation(Location loc) {
        if (loc.getResource() == null) {
            return null;
        }
        return this.locationAnalyser.adaptEnd(loc);
    }
}

