/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.common;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openarchitectureware.workflow.WorkflowContext;
import org.openarchitectureware.workflow.issues.Issues;
import org.openarchitectureware.workflow.lib.AbstractWorkflowComponent2;
import org.openarchitectureware.workflow.monitor.ProgressMonitor;

public class DirectoryCleaner
extends AbstractWorkflowComponent2 {
    private static final String COMPONENT_NAME = "Directory Cleaner";
    private static final Log LOG = LogFactory.getLog(DirectoryCleaner.class);
    private String directory;
    private Set<String> excludes = new HashSet<String>();
    private String[] defaultExcludes = new String[]{".CVS", ".svn"};
    private boolean useDefaultExcludes = true;

    @Deprecated
    public void setDirectories(String directory) {
        LOG.warn((Object)"Property 'directories' is deprecated. Use 'directory' instead.");
        this.setDirectory(directory);
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getLogMessage() {
        return "cleaning directory '" + this.directory + "'";
    }

    protected void invokeInternal(WorkflowContext model, ProgressMonitor monitor, Issues issues) {
        if (this.directory != null) {
            StringTokenizer st = new StringTokenizer(this.directory, ",");
            while (st.hasMoreElements()) {
                String dir = st.nextToken().trim();
                File f = new File(dir);
                if (!f.exists() || !f.isDirectory()) continue;
                LOG.info((Object)("Cleaning " + f.getAbsolutePath()));
                File[] contents = f.listFiles();
                int j = 0;
                while (j < contents.length) {
                    File file = contents[j];
                    if (!this.delete(file)) {
                        LOG.error((Object)("Couldn't delete " + file.getAbsolutePath()));
                    }
                    ++j;
                }
            }
        }
    }

    protected void checkConfigurationInternal(Issues issues) {
        if (this.directory == null) {
            issues.addWarning("No directories specified!");
        }
    }

    public boolean delete(File file) {
        if (file.isDirectory()) {
            String[] children = file.list();
            int i = 0;
            while (i < children.length) {
                boolean success;
                if (!this.isExcluded(file) && !(success = this.delete(new File(file, children[i])))) {
                    return false;
                }
                ++i;
            }
        }
        if (!this.isExcluded(file)) {
            return file.delete();
        }
        return true;
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    private boolean isExcluded(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        String name = file.getName();
        if (this.useDefaultExcludes) {
            String[] stringArray = this.defaultExcludes;
            int n = this.defaultExcludes.length;
            int n2 = 0;
            while (n2 < n) {
                String excl = stringArray[n2];
                if (name.equals(excl)) {
                    return true;
                }
                ++n2;
            }
        }
        return this.excludes.contains(name);
    }
}

