/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.workflow.ant;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.openarchitectureware.workflow.WorkflowRunner;
import org.openarchitectureware.workflow.ant.Param;

public class WorkflowAntTask
extends Java {
    private String file;
    private final List<Param> params = new ArrayList<Param>();

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void execute() throws BuildException {
        this.log("Adding param: " + this.getFile());
        super.createArg().setValue(this.getFile());
        for (Param param : this.params) {
            if (param == null) continue;
            String paramString = "-p" + param.getName() + "=" + param.getValue();
            super.createArg().setValue(paramString);
            this.log("Adding param: " + paramString);
        }
        this.log("Adding param: --ant");
        super.createArg().setValue("--ant");
        super.setFailonerror(true);
        super.setClassname(WorkflowRunner.class.getName());
        try {
            super.execute();
        }
        catch (BuildException ex) {
            if (ex.getCause() != null) {
                ex.getCause().printStackTrace();
            }
            String message = "workflow failed: " + String.valueOf(ex.getMessage());
            if (ex.getCause() != null) {
                message = String.valueOf(message) + " cause: " + String.valueOf(ex.getCause().getMessage());
            }
            throw new BuildException(message, (Throwable)ex);
        }
    }

    public Object createParam() {
        Param param = new Param();
        this.params.add(param);
        return param;
    }
}

