/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.communication;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import org.openarchitectureware.debug.communication.Connection;
import org.openarchitectureware.debug.communication.packets.AbstractPacket;

public class PacketSender
implements Runnable {
    private ArrayList<AbstractPacket> outgoingPackets;
    private Connection connection;
    private boolean interrupt = false;

    public static PacketSender newPacketSender(Connection connection) {
        PacketSender sender = new PacketSender(connection);
        Thread thread = new Thread((Runnable)sender, "PacketSender");
        thread.setDaemon(true);
        thread.start();
        return sender;
    }

    private PacketSender(Connection connection) {
        this.connection = connection;
        this.outgoingPackets = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendPacket(AbstractPacket packet) throws InterruptedIOException {
        if (!this.connection.isConnected()) {
            throw new InterruptedIOException();
        }
        ArrayList<AbstractPacket> arrayList = this.outgoingPackets;
        synchronized (arrayList) {
            this.outgoingPackets.add(packet);
            this.outgoingPackets.notifyAll();
        }
        return packet.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.interrupt = true;
        ArrayList<AbstractPacket> arrayList = this.outgoingPackets;
        synchronized (arrayList) {
            this.outgoingPackets.notifyAll();
        }
    }

    public void run() {
        while (!this.interrupt && this.connection.isConnected()) {
            try {
                this.sendAvailablePackets();
            }
            catch (Exception e) {
                if (!(e instanceof IOException)) {
                    e.printStackTrace();
                }
                this.interrupt = true;
            }
        }
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendAvailablePackets() throws IOException {
        ArrayList<AbstractPacket> packetsToSend = new ArrayList<AbstractPacket>();
        ArrayList<AbstractPacket> arrayList = this.outgoingPackets;
        synchronized (arrayList) {
            while (true) {
                if (this.interrupt || !this.outgoingPackets.isEmpty()) {
                    packetsToSend.addAll(this.outgoingPackets);
                    this.outgoingPackets.clear();
                    break;
                }
                try {
                    this.outgoingPackets.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        for (AbstractPacket packet : packetsToSend) {
            this.connection.writePacket(packet);
        }
    }
}

