/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.debug.communication;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import org.openarchitectureware.debug.communication.Connection;
import org.openarchitectureware.debug.communication.packets.AbstractPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketReceiver
implements Runnable {
    private ArrayList<AbstractPacket> receivedPackets;
    private Connection connection;
    private boolean interrupt = false;
    private Exception exception;

    public static PacketReceiver newPacketReceiver(Connection connection) {
        PacketReceiver receiver = new PacketReceiver(connection);
        Thread thread = new Thread((Runnable)receiver, "PacketReceiver");
        thread.setDaemon(true);
        thread.start();
        return receiver;
    }

    private PacketReceiver(Connection connection) {
        this.connection = connection;
        this.receivedPackets = new ArrayList();
    }

    public AbstractPacket getPacket(Class<? extends AbstractPacket> type, long timeToWait) throws InterruptedIOException {
        return this.getPacket(type, 0, timeToWait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractPacket getPacket(Class<? extends AbstractPacket> type, int refId, long timeToWait) throws InterruptedIOException {
        AbstractPacket packet = null;
        ArrayList<AbstractPacket> arrayList = this.receivedPackets;
        synchronized (arrayList) {
            long remainingTime = timeToWait;
            while ((packet = this.popReceivedPacket(type, refId)) == null && this.connection.isConnected() && !this.interrupt && (timeToWait < 0L || remainingTime > 0L)) {
                long timeBeforeWait = System.currentTimeMillis();
                try {
                    this.waitForPacketAvailable(remainingTime);
                }
                catch (InterruptedException interruptedException) {}
                if (timeToWait < 0L) continue;
                remainingTime -= System.currentTimeMillis() - timeBeforeWait;
            }
        }
        this.checkForException(packet);
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        this.interrupt = true;
        ArrayList<AbstractPacket> arrayList = this.receivedPackets;
        synchronized (arrayList) {
            this.receivedPackets.notifyAll();
        }
    }

    private void waitForPacketAvailable(long timeToWait) throws InterruptedException {
        if (timeToWait == 0L) {
            return;
        }
        if (timeToWait < 0L) {
            this.receivedPackets.wait();
        } else {
            this.receivedPackets.wait(timeToWait);
        }
    }

    private synchronized AbstractPacket popReceivedPacket(Class<? extends AbstractPacket> type, int refId) {
        for (AbstractPacket packet : this.receivedPackets) {
            if (!type.isInstance(packet) || refId != 0 && packet.refId != refId) continue;
            this.receivedPackets.remove(packet);
            return packet;
        }
        return null;
    }

    private void checkForException(AbstractPacket packet) throws InterruptedIOException {
        if (packet != null) {
            return;
        }
        if (this.exception != null && !(this.exception instanceof IOException)) {
            this.exception.printStackTrace();
        }
        if (this.interrupt) {
            throw new InterruptedIOException("packet receiver is going to close");
        }
        if (this.exception != null) {
            throw new InterruptedIOException(this.exception.getMessage());
        }
        throw new InterruptedIOException("timeout reading a packet");
    }

    @Override
    public void run() {
        try {
            while (!this.interrupt && this.connection.isConnected()) {
                this.readAvailablePacket();
            }
        }
        catch (Exception e) {
            this.exception = e;
            this.close();
        }
    }

    private void readAvailablePacket() throws IOException {
        this.addPacketToList(this.connection.readPacket());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPacketToList(AbstractPacket packet) {
        ArrayList<AbstractPacket> arrayList = this.receivedPackets;
        synchronized (arrayList) {
            this.receivedPackets.add(packet);
            this.receivedPackets.notifyAll();
        }
    }
}

