/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import junit.extensions.jfcunit.ExitException;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.WindowMonitor;
import junit.extensions.jfcunit.eventdata.AbstractKeyEventData;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.DragEventData;
import junit.extensions.jfcunit.eventdata.KeyEventData;
import junit.extensions.jfcunit.eventdata.MouseWheelEventData;
import junit.extensions.jfcunit.finder.AbstractWindowFinder;
import junit.extensions.jfcunit.finder.ComponentFinder;
import junit.extensions.jfcunit.finder.DialogFinder;
import junit.extensions.jfcunit.finder.Finder;
import junit.extensions.jfcunit.finder.FrameFinder;
import junit.extensions.jfcunit.finder.NamedComponentFinder;
import junit.extensions.jfcunit.keyboard.DefaultKeyMapping;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;
import junit.extensions.jfcunit.keyboard.KeyMapping;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public abstract class TestHelper {
    public static final long DEFAULTSLEEP = 300L;
    private static JFCTestCase s_test;
    private static KeyMapping s_keyMapping;
    private static HashMap s_systemWindows;
    private static final Object LOCK;
    private int m_step = 10;
    static /* synthetic */ Class class$javax$swing$JLabel;
    static /* synthetic */ Class class$javax$swing$JFileChooser;

    protected TestHelper() {
    }

    public static Window[] getAllWindows() {
        return WindowMonitor.getWindows();
    }

    public static void setCurrentTestCase(JFCTestCase tc) {
        s_test = tc;
    }

    public static JFCTestCase getCurrentTestCase() {
        return s_test;
    }

    public static final Set getSystemWindows() {
        return Collections.unmodifiableSet(s_systemWindows.keySet());
    }

    public static final void addSystemWindow(String matchTitleRE) throws RESyntaxException {
        if (matchTitleRE == null) {
            return;
        }
        RE patternMatcher = new RE(matchTitleRE);
        s_systemWindows.put(matchTitleRE, patternMatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setKeyMapping(KeyMapping km) {
        Object object = LOCK;
        synchronized (object) {
            s_keyMapping = km;
            LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyMapping getKeyMapping() {
        Object object = LOCK;
        synchronized (object) {
            if (s_keyMapping == null) {
                TestHelper.setKeyMapping(new DefaultKeyMapping());
            }
            LOCK.notifyAll();
        }
        return s_keyMapping;
    }

    public static List getShowingDialogs() {
        return TestHelper.getShowingDialogs((String)null);
    }

    public static List getShowingDialogs(Window win) {
        return TestHelper.getShowingDialogs(win, null);
    }

    public static List getShowingDialogs(String titlematch) {
        List openWindows = TestHelper.getWindows();
        openWindows.add(new JDialog().getOwner());
        Window[] owners = new Window[openWindows.size() + 1];
        owners = openWindows.toArray(owners);
        return TestHelper.getShowingDialogs(owners, titlematch);
    }

    public static List getShowingDialogs(Window win, String titlematch) {
        return TestHelper.getShowingDialogs(new Window[]{win}, titlematch);
    }

    public static List getShowingDialogs(Window[] owners, String titlematch) {
        return TestHelper.getShowingDialogs(new ArrayList(), owners, titlematch);
    }

    public static List getShowingDialogs(List ret, Window[] owners, String titlematch) {
        return TestHelper.getShowingDialogs(ret, owners, new DialogFinder(titlematch));
    }

    public static List getShowingDialogs(List ret, Window[] owners, Finder finder) {
        ArrayList<Window> arr = ret == null ? new ArrayList<Window>() : ret;
        if (owners == null || finder == null) {
            return arr;
        }
        for (int i = 0; i < owners.length; ++i) {
            if (owners[i] == null) continue;
            if (finder.testComponent(owners[i]) && !ret.contains(owners[i])) {
                arr.add(owners[i]);
            }
            TestHelper.getShowingDialogs(arr, owners[i].getOwnedWindows(), finder);
        }
        return arr;
    }

    public static List getWindows(AbstractWindowFinder finder) {
        return finder.findAll();
    }

    public static List getWindows(List ret, Window[] windows, String titlematch) {
        return TestHelper.getWindows(ret, windows, new FrameFinder(titlematch));
    }

    public static List getWindows(List ret, Window[] windows, Finder finder) {
        return AbstractWindowFinder.getWindows(ret, windows, finder);
    }

    public static Point calcNextPoint(Point src, Point dest, int step) {
        Point dir = new Point(TestHelper.getDir(src.x, dest.x), TestHelper.getDir(src.y, dest.y));
        if (TestHelper.isBounded(src.x + dir.x * step, dest.x, src.x)) {
            dir.x *= step;
        }
        if (TestHelper.isBounded(src.y + dir.y * step, dest.y, src.y)) {
            dir.y *= step;
        }
        dir.translate(src.x, src.y);
        return dir;
    }

    public static void cleanUp(JFCTestCase testCase) {
        TestHelper.cleanUp(testCase, 300L);
    }

    public static void cleanUp(JFCTestCase testCase, long awtSleepTime) {
        Iterator iter = TestHelper.getWindows().iterator();
        while (iter.hasNext()) {
            boolean ignore = false;
            Window w = (Window)iter.next();
            String title = null;
            if (w instanceof Dialog) {
                title = ((Dialog)w).getTitle();
            } else if (w instanceof Frame) {
                title = ((Frame)w).getTitle();
            }
            if (title != null) {
                Iterator sw = s_systemWindows.values().iterator();
                while (sw.hasNext() && !ignore) {
                    RE re = (RE)sw.next();
                    if (!re.match(title)) continue;
                    ignore = true;
                }
            }
            if (ignore) continue;
            TestHelper.disposeWindow(w, testCase, awtSleepTime);
        }
    }

    public static void disposeWindow(Window window, JFCTestCase testCase) {
        TestHelper.disposeWindow(window, testCase, 300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeWindow(Window window, JFCTestCase testCase, long awtSleepTime) {
        if (window != null) {
            boolean awt = testCase.isAWTRunning();
            if (awt) {
                testCase.pauseAWT();
            }
            try {
                if (!(window instanceof JDialog)) {
                    List dialogs = TestHelper.getShowingDialogs(window);
                    for (int i = 0; i < dialogs.size(); ++i) {
                        TestHelper.disposeWindow((JDialog)dialogs.get(i), testCase, awtSleepTime);
                    }
                }
                window.setVisible(false);
                testCase.flushAWT();
                if (!awt) {
                    testCase.pauseAWT();
                }
                try {
                    window.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(window, 201));
                }
                catch (ExitException exe) {
                }
                Object var8_7 = null;
                testCase.setSleepTime(awtSleepTime);
                testCase.flushAWT();
                if (!awt) {
                    testCase.pauseAWT();
                }
                testCase.awtSleep();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                testCase.setSleepTime(awtSleepTime);
                testCase.flushAWT();
                if (!awt) {
                    testCase.pauseAWT();
                }
                testCase.awtSleep();
                throw throwable;
            }
        }
    }

    public static final void removeAllSystemWindows() {
        s_systemWindows.clear();
    }

    public static final void removeSystemWindow(String matchTitleRE) {
        s_systemWindows.remove(matchTitleRE);
    }

    public String getMessageFromJDialog(JDialog dialog) {
        if (dialog == null || !dialog.isShowing()) {
            return null;
        }
        List list = Finder.findComponentList(new ComponentFinder(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = TestHelper.class$("javax.swing.JLabel")) : class$javax$swing$JLabel), dialog, new ArrayList(), 10);
        for (int i = 0; i < list.size(); ++i) {
            JLabel label = (JLabel)list.get(i);
            if (label == null || label.getText() == null) continue;
            return label.getText();
        }
        return null;
    }

    public static Window getWindow(String title) {
        return TestHelper.getWindow(new FrameFinder(title));
    }

    public static Window getWindow(AbstractWindowFinder finder) {
        Iterator iter = TestHelper.getWindows(finder).iterator();
        if (!iter.hasNext()) {
            return null;
        }
        return (Window)iter.next();
    }

    public static List getWindows() {
        FrameFinder f = new FrameFinder(null);
        f.setWait(1);
        return TestHelper.getWindows(f);
    }

    public static List getWindows(String titlematch) {
        return TestHelper.getWindows(new FrameFinder(titlematch));
    }

    public JFileChooser getShowingJFileChooser(Window win) {
        List choosers = this.getShowingJFileChoosers(win);
        if (choosers.isEmpty()) {
            return null;
        }
        return (JFileChooser)choosers.get(0);
    }

    public List getShowingJFileChoosers(Window win) {
        ArrayList<JFileChooser> ret = new ArrayList<JFileChooser>();
        Window[] owned = win.getOwnedWindows();
        ComponentFinder finder = new ComponentFinder(class$javax$swing$JFileChooser == null ? (class$javax$swing$JFileChooser = TestHelper.class$("javax.swing.JFileChooser")) : class$javax$swing$JFileChooser);
        for (int i = 0; i < owned.length; ++i) {
            if (!(owned[i] instanceof JDialog)) continue;
            List subComps = Finder.findComponentList(finder, owned[i], new ArrayList(), 0);
            Iterator iter = subComps.iterator();
            while (iter.hasNext()) {
                JFileChooser chooser = (JFileChooser)iter.next();
                if (!((Finder)finder).testComponent(chooser)) continue;
                ret.add(chooser);
            }
        }
        return ret;
    }

    public static Component findComponent(Class compCls, int index) {
        return new ComponentFinder(compCls).find(index);
    }

    public static Component findComponent(Class compCls, Container cont, int index) {
        return new ComponentFinder(compCls).find(cont, index);
    }

    public static Component findComponent(Finder finder, int index) {
        return finder.find(index);
    }

    public static Component findComponent(Finder finder, Container cont, int index) {
        return finder.find(cont, index);
    }

    public static Component findNamedComponent(Class compCls, int index) {
        return new NamedComponentFinder(compCls, null).find(index);
    }

    public static Component findNamedComponent(String name, int index) {
        return new NamedComponentFinder(null, name).find(index);
    }

    public static Component findNamedComponent(Class compCls, String name, int index) {
        return new NamedComponentFinder(compCls, name).find(index);
    }

    public static Component findNamedComponent(String name, Container cont, int index) {
        return TestHelper.findNamedComponent(null, name, cont, index);
    }

    public static Component findNamedComponent(Class aClass, Container cont, int index) {
        return TestHelper.findNamedComponent(aClass, null, cont, index);
    }

    public static Component findNamedComponent(Class aClass, String name, Container cont, int index) {
        return new NamedComponentFinder(aClass, name).find(cont, index);
    }

    public static int indexOf(Finder finder, Container cont, Component comp) {
        Container[] containers = null;
        if (cont != null) {
            if (!cont.isShowing()) {
                finder.setIgnoreVisibility(true);
            }
            containers = new Container[]{cont};
        } else {
            containers = TestHelper.getAllWindows();
        }
        int index = 0;
        for (int i = 0; i < containers.length; ++i) {
            List list = Finder.findComponentList(finder, containers[i], new ArrayList(), 999);
            if (list.contains(comp)) {
                return index + list.indexOf(comp);
            }
            index += list.size();
        }
        return -1;
    }

    public void setStep(int step) {
        this.m_step = step;
    }

    public int getStep() {
        return this.m_step;
    }

    public void enterClickAndLeave(AbstractMouseEventData evtData) {
        if (evtData == null) {
            return;
        }
        evtData.getTestCase().pauseAWT();
        if (!evtData.prepareComponent()) {
            evtData.getTestCase().resumeAWT();
            return;
        }
        evtData.getTestCase().resumeAWT();
        int numberOfClicks = evtData.getNumberOfClicks();
        int modifiers = evtData.getModifiers();
        boolean isPopupTrigger = evtData.getPopupTrigger();
        Component ultimate = evtData.getRoot();
        evtData.getTestCase().flushAWT();
        Point screen = evtData.getLocationOnScreen();
        this.pressModifiers(ultimate, TestHelper.mouseToKeyModifiers(modifiers));
        this.mouseMoved(ultimate, screen.x - 5, screen.y - 5);
        this.mouseMoved(ultimate, screen.x, screen.y);
        for (int click = 1; click <= numberOfClicks; ++click) {
            this.mousePressed(ultimate, modifiers, click, isPopupTrigger);
            this.mouseReleased(ultimate, modifiers, click, isPopupTrigger);
        }
        this.releaseModifiers(ultimate, TestHelper.mouseToKeyModifiers(modifiers));
        evtData.getTestCase().flushAWT();
    }

    public void enterDragAndLeave(AbstractMouseEventData srcEvtData, AbstractMouseEventData dstEvtData, int incr) {
        DragEventData ded = new DragEventData(srcEvtData.getTestCase(), srcEvtData, dstEvtData);
        this.setStep(incr);
        this.enterDragAndLeave(ded);
    }

    public void enterDragAndLeave(DragEventData ded) {
        ded.getTestCase().pauseAWT();
        if (!ded.prepareComponent()) {
            ded.getTestCase().resumeAWT();
            return;
        }
        ded.getTestCase().resumeAWT();
        int numberOfClicks = ded.getSource().getNumberOfClicks();
        int modifiers = ded.getSource().getModifiers();
        int keyModifiers = TestHelper.mouseToKeyModifiers(modifiers);
        int mouseButtonMask = modifiers & 0x1C;
        boolean isPopupTrigger = ded.getSource().getPopupTrigger();
        Component ultimate = ded.getSource().getComponent();
        Point p = ded.getSource().getLocationOnScreen();
        ded.getTestCase().flushAWT();
        this.mouseMoved(ultimate, p.x - 5, p.y - 5);
        this.mouseMoved(ultimate, p.x, p.y);
        this.pressModifiers(ultimate, keyModifiers);
        this.mousePressed(ultimate, mouseButtonMask, 0, isPopupTrigger);
        Point[] pts = ded.getPoints();
        for (int i = 0; i < pts.length; ++i) {
            this.mouseMoved(ultimate, pts[i].x, pts[i].y);
        }
        this.mouseReleased(ultimate, mouseButtonMask, numberOfClicks, isPopupTrigger);
        this.releaseModifiers(ultimate, keyModifiers);
        ded.getTestCase().flushAWT();
    }

    public void enterMouseWheel(MouseWheelEventData evtData) {
        if (evtData == null) {
            return;
        }
        evtData.getTestCase().pauseAWT();
        if (!evtData.prepareComponent()) {
            evtData.getTestCase().resumeAWT();
            return;
        }
        evtData.getTestCase().resumeAWT();
        int numberOfClicks = evtData.getWheelRotation();
        int modifiers = evtData.getModifiers();
        boolean isPopupTrigger = evtData.getPopupTrigger();
        Component ultimate = evtData.getSource();
        Point screen = evtData.getLocationOnScreen();
        int mods = TestHelper.mouseToKeyModifiers(modifiers);
        this.pressModifiers(ultimate, mods);
        evtData.getTestCase().flushAWT();
        this.mouseMoved(ultimate, screen.x - 5, screen.y - 5);
        this.mouseMoved(ultimate, screen.x, screen.y);
        evtData.getTestCase().flushAWT();
        int inc = 1;
        if (numberOfClicks < 0) {
            inc = -1;
        }
        int mx = numberOfClicks;
        if (numberOfClicks < 0) {
            mx *= -1;
        }
        for (int i = 0; i < mx; ++i) {
            this.mouseWheel(ultimate, evtData.getScrollAmount(), inc);
        }
        evtData.getTestCase().flushAWT();
        this.releaseModifiers(ultimate, mods);
        evtData.getTestCase().flushAWT();
    }

    public void sendKeyAction(KeyEventData evtData) {
        this.sendString(evtData);
    }

    public void sendString(AbstractKeyEventData evtData) {
        if (evtData == null) {
            return;
        }
        evtData.getTestCase().pauseAWT();
        if (!evtData.prepareComponent()) {
            evtData.getTestCase().resumeAWT();
            return;
        }
        evtData.getTestCase().resumeAWT();
        Component ultimate = evtData.getRoot();
        int modifiers = evtData.getModifiers();
        evtData.getTestCase().flushAWT();
        this.pressModifiers(ultimate, modifiers);
        JFCKeyStroke[] keyStroke = evtData.getKeyStrokes();
        for (int k = 0; k < keyStroke.length; ++k) {
            this.adjustModifiers(ultimate, modifiers, keyStroke[k].getModifiers());
            modifiers = keyStroke[k].getModifiers();
            this.keyPressed(ultimate, keyStroke[k]);
            this.keyReleased(ultimate, keyStroke[k]);
        }
        this.releaseModifiers(ultimate, modifiers);
        evtData.getTestCase().flushAWT();
    }

    protected static int mouseToKeyModifiers(int modifiers) {
        int keyModifiers = modifiers;
        int mouseButtons = 28;
        return keyModifiers &= 0xFFFFFFFF ^ mouseButtons;
    }

    protected final void adjustModifiers(Component ultimate, int modifiers, int newModifiers) {
        JFCKeyStroke[] strokes;
        if (modifiers == newModifiers) {
            return;
        }
        boolean s1 = (modifiers & 1) > 0;
        boolean s2 = (newModifiers & 1) > 0;
        boolean c1 = (modifiers & 2) > 0;
        boolean c2 = (newModifiers & 2) > 0;
        boolean m1 = (modifiers & 4) > 0;
        boolean m2 = (newModifiers & 4) > 0;
        boolean a1 = (modifiers & 8) > 0;
        boolean a2 = (newModifiers & 8) > 0;
        boolean g1 = (modifiers & 0x20) > 0;
        boolean g2 = (newModifiers & 0x20) > 0;
        int mods = modifiers;
        if (s1 && !s2) {
            strokes = TestHelper.getKeyMapping().getKeyStrokes(16);
            strokes[0].setModifiers(mods &= 0xFFFFFFFE);
            this.keyReleased(ultimate, strokes[0]);
        } else if (!s1 && s2) {
            strokes = TestHelper.getKeyMapping().getKeyStrokes(16);
            strokes[0].setModifiers(mods |= 1);
            this.keyPressed(ultimate, strokes[0]);
        }
        if (c1 && !c2) {
            strokes = TestHelper.getKeyMapping().getKeyStrokes(17);
            strokes[0].setModifiers(mods &= 0xFFFFFFFD);
            this.keyReleased(ultimate, strokes[0]);
        } else if (!c1 && c2) {
            strokes = TestHelper.getKeyMapping().getKeyStrokes(17);
            strokes[0].setModifiers(mods |= 2);
            this.keyPressed(ultimate, strokes[0]);
        }
        if (a1 && !a2) {
            strokes = TestHelper.getKeyMapping().getKeyStrokes(18);
            strokes[0].setModifiers(mods &= 0xFFFFFFF7);
            this.keyReleased(ultimate, strokes[0]);
        } else if (!a1 && a2) {
            strokes = TestHelper.getKeyMapping().getKeyStrokes(18);
            strokes[0].setModifiers(mods |= 8);
            this.keyPressed(ultimate, strokes[0]);
        }
        if (g1 && !g2) {
            strokes = TestHelper.getKeyMapping().getKeyStrokes(65406);
            strokes[0].setModifiers(mods &= 0xFFFFFFDF);
            this.keyReleased(ultimate, strokes[0]);
        } else if (!g1 && g2) {
            strokes = TestHelper.getKeyMapping().getKeyStrokes(65406);
            strokes[0].setModifiers(mods |= 0x20);
            this.keyPressed(ultimate, strokes[0]);
        }
        if (m1 && !m2) {
            strokes = TestHelper.getKeyMapping().getKeyStrokes(157);
            strokes[0].setModifiers(mods &= 0xFFFFFFFB);
            this.keyReleased(ultimate, strokes[0]);
        } else if (!m1 && m2) {
            strokes = TestHelper.getKeyMapping().getKeyStrokes(157);
            strokes[0].setModifiers(mods |= 4);
            this.keyPressed(ultimate, strokes[0]);
        }
    }

    protected final void pressModifiers(Component ultimate, int modifiers) {
        this.adjustModifiers(ultimate, 0, modifiers);
    }

    protected final void releaseModifiers(Component ultimate, int modifiers) {
        this.adjustModifiers(ultimate, modifiers, 0);
    }

    protected static boolean isBounded(int val, int vMin, int vMax) {
        int min = Math.min(vMin, vMax);
        int max = Math.max(vMin, vMax);
        return min < val && val < max;
    }

    protected abstract void keyPressed(Component var1, JFCKeyStroke var2);

    protected abstract void keyReleased(Component var1, JFCKeyStroke var2);

    protected abstract void mouseMoved(Component var1, int var2, int var3);

    protected abstract void mousePressed(Component var1, int var2, int var3, boolean var4);

    protected abstract void mouseReleased(Component var1, int var2, int var3, boolean var4);

    protected abstract void mouseWheel(Component var1, int var2, int var3);

    private static int getDir(int src, int dest) {
        if (src == dest) {
            return 0;
        }
        if (src < dest) {
            return 1;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_keyMapping = null;
        s_systemWindows = new HashMap();
        LOCK = new Object();
    }
}

