/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.timer;

import ahc.util.timer.StopWatch;
import java.text.NumberFormat;

public abstract class TimerExperiment {
    private final int _numMeasured;
    private final int _lapTimeInterval;
    private final String _name;
    private final NumberFormat _format = NumberFormat.getNumberInstance();

    public TimerExperiment(String name, int numMeasured) {
        this(name, numMeasured, numMeasured / 10);
    }

    public TimerExperiment(String name, int numMeasured, int lapTimeInterval) {
        this._name = name;
        this._lapTimeInterval = lapTimeInterval;
        this._numMeasured = numMeasured;
    }

    public StopWatch execute() {
        StopWatch result = new StopWatch(this._name);
        for (int i = 0; i < this._numMeasured; ++i) {
            this.doIt();
            if (!this.shouldRememberLapTime(i)) continue;
            result.remember("Time after " + this._format.format(i + 1) + " iterations");
        }
        result.stop();
        return result;
    }

    private boolean shouldRememberLapTime(int i) {
        return i % this._lapTimeInterval == this._lapTimeInterval - 1;
    }

    public abstract void doIt();
}

