/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.string;

import ahc.util.string.LiteralHandler;
import ahc.util.string.PercentLiteralHandlerType;
import ahc.util.string.sprintf.DoubleHandlerType;
import ahc.util.string.sprintf.IntHandlerType;
import ahc.util.string.sprintf.SPrintfHandler;
import ahc.util.string.sprintf.SPrintfHandlerType;
import ahc.util.string.sprintf.StringHandlerType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SPrintf {
    public static final char ESC_CHAR = '%';
    private static final List _handlerTypes = new ArrayList();
    private final String _pattern;
    private final List _instanceHandlers = new ArrayList();
    private int _offsCurPart = 0;

    public SPrintf(String pattern) {
        this._pattern = pattern;
        while (this._offsCurPart < pattern.length()) {
            if (this.isEsc(this._offsCurPart)) {
                this._instanceHandlers.add(this.getHandlerType());
                continue;
            }
            int i = 0;
            while (this._offsCurPart + i < pattern.length() && !this.isEsc(this._offsCurPart + i)) {
                ++i;
            }
            this._instanceHandlers.add(new LiteralHandler(pattern.substring(this._offsCurPart, this._offsCurPart + i)));
            this._offsCurPart += i;
        }
    }

    private SPrintfHandler getHandlerType() {
        Iterator iter = _handlerTypes.iterator();
        while (iter.hasNext()) {
            SPrintfHandlerType curHandler = (SPrintfHandlerType)iter.next();
            int numPatternChars = curHandler.numPatternChars(this._pattern.substring(this._offsCurPart));
            if (numPatternChars <= 0) continue;
            SPrintfHandler result = curHandler.getHandler(this._pattern.substring(this._offsCurPart));
            this._offsCurPart += numPatternChars;
            return result;
        }
        throw new IllegalArgumentException("No handler found for pattern at offset " + this._offsCurPart + ": " + this._pattern.substring(this._offsCurPart));
    }

    private boolean isEsc(int offsCurPart) {
        return this._pattern.charAt(offsCurPart) == '%';
    }

    public String print(Object[] data) {
        StringBuffer result = new StringBuffer();
        int indData = 0;
        Iterator iter = this._instanceHandlers.iterator();
        while (iter.hasNext()) {
            SPrintfHandler curHandler;
            result.append(curHandler.handle((curHandler = (SPrintfHandler)iter.next()).hasParameter() ? data[indData++] : null));
        }
        return result.toString();
    }

    public String print(Object data) {
        return this.print(new Object[]{data});
    }

    public String print(Object data1, Object data2) {
        return this.print(new Object[]{data1, data2});
    }

    public String print(Object data1, Object data2, Object data3) {
        return this.print(new Object[]{data1, data2, data3});
    }

    public String print(Object data1, Object data2, Object data3, Object data4) {
        return this.print(new Object[]{data1, data2, data3, data4});
    }

    public String print(Object data1, Object data2, Object data3, Object data4, Object data5) {
        return this.print(new Object[]{data1, data2, data3, data4, data5});
    }

    public String print(Object data1, Object data2, Object data3, Object data4, Object data5, Object data6) {
        return this.print(new Object[]{data1, data2, data3, data4, data5, data6});
    }

    public static String print(String pattern, Object[] data) {
        return new SPrintf(pattern).print(data);
    }

    public static void registerHandler(SPrintfHandlerType handler) {
        _handlerTypes.add(0, handler);
    }

    static {
        SPrintf.registerHandler(new PercentLiteralHandlerType());
        SPrintf.registerHandler(new DoubleHandlerType());
        SPrintf.registerHandler(new StringHandlerType());
        SPrintf.registerHandler(new IntHandlerType());
    }
}

