/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.Cache;
import ahc.collection.Collection;
import ahc.collection.Iterator;
import ahc.collection.List;
import ahc.collection.Map;
import ahc.collection.Set;
import ahc.collection.access.AccessStrategy;
import ahc.collection.mod.ExternalIterator;
import ahc.collection.mod.Function1;
import ahc.collection.mod.Predicate1;
import ahc.collection.store.Store;
import ahc.exception.TunnelingException;
import java.util.Arrays;
import java.util.ListIterator;

public class GenericCollection
implements List,
Set {
    private final Store _store;
    private final AccessStrategy _accessStrategy;

    public GenericCollection(Store store, AccessStrategy accessStrategy) {
        this._store = store;
        this._accessStrategy = accessStrategy;
    }

    public int size() {
        return this._store.size();
    }

    public boolean isEmpty() {
        return this._store.isEmpty();
    }

    AccessStrategy getAccessStrategy() {
        return this._accessStrategy;
    }

    Store getStore() {
        return this._store;
    }

    public boolean contains(Object o) {
        return this._accessStrategy.first(this._store, o) != null;
    }

    public boolean containsAll(java.util.Collection c) {
        java.util.Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray() {
        return this._store.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this._store.toArray(a);
    }

    public Object get(int index) {
        return this._accessStrategy.get(this._store, index);
    }

    public int indexOf(Object o) {
        Iterator iter = this._accessStrategy.first(this._store, o);
        return iter != null ? iter.currentIndex() : -1;
    }

    public int firstIndexOf(Object o) {
        return this.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        Iterator iter = this._accessStrategy.last(this._store, o);
        return iter != null ? iter.currentIndex() : -1;
    }

    public boolean add(Object o) {
        return this._accessStrategy.add(this._store, o);
    }

    public boolean addAll(java.util.Collection c) {
        boolean result = false;
        java.util.Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this._accessStrategy.add(this._store, iter.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean addAll(Object[] newItems) {
        if (newItems == null) {
            return false;
        }
        return this.addAll(Arrays.asList(newItems));
    }

    public void add(int index, Object element) {
        this._accessStrategy.add(this._store, this._store.iter(index), element);
    }

    public boolean addAll(int index, java.util.Collection c) {
        boolean result = false;
        Iterator dest = this._store.iter(index);
        java.util.Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this._accessStrategy.add(this._store, dest, iter.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean prepend(Object o) {
        return this._accessStrategy.prepend(this._store, o);
    }

    public boolean append(Object o) {
        return this._accessStrategy.append(this._store, o);
    }

    public Object set(int index, Object element) {
        Iterator iter = this._store.iter(index);
        Object result = iter.current();
        iter.set(element);
        return result;
    }

    public boolean remove(Object o) {
        return this._store.remove(o);
    }

    public Object remove(int index) {
        Iterator iter = this._store.iter(index);
        Object result = iter.current();
        iter.remove();
        return result;
    }

    public boolean removeAll(java.util.Collection c) {
        boolean result = false;
        java.util.Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this._accessStrategy.remove(this._store, iter.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean retainAll(java.util.Collection c) {
        int oldSize = this.size();
        Iterator iter = this.begin();
        while (iter.hasCurrent()) {
            if (!c.contains(iter.current())) {
                iter.remove();
            }
            iter.next();
        }
        return oldSize != this.size();
    }

    public void clear() {
        this._store.clear();
    }

    public Iterator before() {
        return this._accessStrategy.before(this._store);
    }

    public Iterator begin() {
        return this._accessStrategy.begin(this._store);
    }

    public Iterator end() {
        return this._accessStrategy.end(this._store);
    }

    public Iterator after() {
        return this._accessStrategy.after(this._store);
    }

    public Iterator iter(int index) {
        return this._accessStrategy.iter(this._store, index);
    }

    public Iterator first(Object o) {
        return this._accessStrategy.first(this._store, o);
    }

    public Iterator last(Object o) {
        return this._accessStrategy.last(this._store, o);
    }

    public java.util.Iterator iterator() {
        return this.before();
    }

    public ListIterator listIterator() {
        return this.before();
    }

    public ListIterator listIterator(int index) {
        return this.iter(index);
    }

    public java.util.List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public void foreach(ExternalIterator iterator) {
        try {
            iterator.doBefore();
            boolean first = true;
            int ind = 0;
            Iterator iter = this.begin();
            while (iter.hasCurrent()) {
                if (!first) {
                    iterator.doBetween();
                }
                first = false;
                iterator.doElement(iter.current(), ind++);
                iter.next();
            }
            iterator.doAfter();
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
    }

    public List cloneEmptyList() {
        return (List)this.cloneEmpty();
    }

    public Collection cloneEmpty() {
        return new GenericCollection(this._store.cloneEmpty(), this._accessStrategy);
    }

    public Object clone() {
        return new GenericCollection((Store)this._store.clone(), this._accessStrategy);
    }

    public Set cloneEmptySet() {
        return (Set)this.cloneEmpty();
    }

    public Collection immutableView() {
        return this.immutableGenericView();
    }

    private GenericCollection immutableGenericView() {
        return new GenericCollection(this._store.immutableView(), this._accessStrategy);
    }

    public List immutableListView() {
        return this.immutableGenericView();
    }

    public Set immutableSetView() {
        return this.immutableGenericView();
    }

    public Map split(Function1 function) {
        Cache cache = new Cache(){

            protected Object createNew(Object key) {
                return GenericCollection.this.cloneEmpty();
            }
        };
        try {
            Iterator iter = this.begin();
            while (iter.hasCurrent()) {
                ((Collection)cache.get(function.eval(iter.current()))).add(iter.current());
                iter.next();
            }
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
        return cache.getMap();
    }

    public boolean matchesAll(Predicate1 pred) {
        try {
            Iterator iter = this.begin();
            while (iter.hasCurrent()) {
                if (!pred.matches(iter.current())) {
                    return false;
                }
                iter.next();
            }
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
        return true;
    }

    public boolean matchesAny(Predicate1 pred) {
        try {
            Iterator iter = this.begin();
            while (iter.hasCurrent()) {
                if (pred.matches(iter.current())) {
                    return true;
                }
                iter.next();
            }
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
        return false;
    }

    public Object firstMatch(Predicate1 pred) {
        try {
            Iterator iter = this.begin();
            while (iter.hasCurrent()) {
                if (pred.matches(iter.current())) {
                    return iter.current();
                }
                iter.next();
            }
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
        return null;
    }

    public Collection allMatches(Predicate1 pred) {
        Collection result = this.cloneEmpty();
        try {
            Iterator iter = this.begin();
            while (iter.hasCurrent()) {
                if (pred.matches(iter.current())) {
                    result.add(iter.current());
                }
                iter.next();
            }
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
        return result;
    }

    public int numMatches(Predicate1 pred) {
        int result = 0;
        try {
            Iterator iter = this.begin();
            while (iter.hasCurrent()) {
                if (pred.matches(iter.current())) {
                    ++result;
                }
                iter.next();
            }
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
        return result;
    }

    public Collection transform(Function1 function) {
        Collection result = this.cloneEmpty();
        try {
            Iterator iter = this.begin();
            while (iter.hasCurrent()) {
                result.add(function.eval(iter.current()));
                iter.next();
            }
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        boolean first = true;
        Iterator iter = this.begin();
        while (iter.hasCurrent()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(iter.current());
            iter.next();
        }
        result.append("]");
        return result.toString();
    }
}

