/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.Collection;
import ahc.collection.Map;
import ahc.collection.MapHelper;
import ahc.collection.Set;
import ahc.exception.TunnelingException;

public abstract class Cache {
    private final Map _cache = MapHelper.createMap();

    public Object get(Object key) {
        Object result = this._cache.get(key);
        try {
            if (result == null) {
                result = this.createNew(key);
                this._cache.put(key, result);
            }
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
        return result;
    }

    public Set getKeys() {
        return this._cache.keys();
    }

    public Collection getValues() {
        return this._cache.vals();
    }

    public Map getMap() {
        return this._cache;
    }

    protected abstract Object createNew(Object var1) throws Exception;
}

