/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.util.NamingUtils;

public class ContextUtilities {
    private ORB m_orb;
    private Logger m_logger = null;
    private NamingContextExt m_initalContext;

    public ContextUtilities(ORB orb) {
        this.m_orb = orb;
    }

    public NamingContextExt getInitialContext() {
        if (this.m_initalContext != null) {
            return this.m_initalContext;
        }
        try {
            Object m_initalContext_obj = this.m_orb.resolve_initial_references("NameService");
            this.m_initalContext = NamingContextExtHelper.narrow(m_initalContext_obj);
            return this.m_initalContext;
        }
        catch (InvalidName in) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("InvalidName NameService!", (Throwable)in);
            }
            return null;
        }
    }

    public boolean bind(String name, Object object) {
        try {
            if (name.indexOf("/") != -1 || name.indexOf(".") != -1) {
                return this.full_bind(name, object);
            }
            NameComponent[] nameComponent = NamingUtils.to_name(name);
            this.getInitialContext().bind(nameComponent, object);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean rebind(String name, Object object) {
        try {
            if (name.indexOf("/") != -1 || name.indexOf(".") != -1) {
                return this.full_rebind(name, object, this.getInitialContext());
            }
            NameComponent[] nameComponent = NamingUtils.to_name(name);
            this.getInitialContext().rebind(nameComponent, object);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Object resolve(String name) {
        try {
            if (name.indexOf("/") == -1 && name.indexOf(".") == -1) {
                NameComponent[] nameComponent = NamingUtils.to_name(name);
                return this.getInitialContext().resolve(nameComponent);
            }
            NameComponent[] full_context = this.getInitialContext().to_name(name);
            return this.getInitialContext().resolve(full_context);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean full_rebind(String name, Object object, NamingContextExt init_context) {
        try {
            NameComponent[] nameComponent = NamingUtils.to_name(name);
            NamingContext prev_context = init_context;
            boolean not_found = false;
            int i = 0;
            while (i < nameComponent.length - 1) {
                NameComponent context = nameComponent[i];
                if (not_found) {
                    prev_context = this.createNewContext(prev_context, context);
                } else {
                    try {
                        NameComponent[] tempNameComponent = new NameComponent[]{context};
                        Object prev_context_obj = prev_context.resolve(tempNameComponent);
                        prev_context = NamingContextHelper.narrow(prev_context_obj);
                    }
                    catch (NotFound nf) {
                        prev_context = this.createNewContext(prev_context, context);
                        not_found = true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                ++i;
            }
            NameComponent[] objectNameComponent = new NameComponent[]{nameComponent[nameComponent.length - 1]};
            prev_context.rebind(objectNameComponent, object);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private boolean full_bind(String name, Object object_value) {
        try {
            NameComponent[] nameComponent = NamingUtils.to_name(name);
            NamingContext prev_context = this.getInitialContext();
            boolean not_found = false;
            int i = 0;
            while (i < nameComponent.length - 1) {
                NameComponent context = nameComponent[i];
                if (not_found) {
                    prev_context = this.createNewContext(prev_context, context);
                } else {
                    try {
                        NameComponent[] tempNameComponent = new NameComponent[]{context};
                        Object prev_context_obj = prev_context.resolve(tempNameComponent);
                        prev_context = NamingContextHelper.narrow(prev_context_obj);
                    }
                    catch (NotFound nf) {
                        prev_context = this.createNewContext(prev_context, context);
                        not_found = true;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                ++i;
            }
            NameComponent[] objectNameComponent = new NameComponent[]{nameComponent[nameComponent.length - 1]};
            prev_context.bind(objectNameComponent, object_value);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private NamingContext createNewContext(NamingContext prev_context, NameComponent context) {
        try {
            NameComponent[] tempNameComponent = new NameComponent[]{context};
            return prev_context.bind_new_context(tempNameComponent);
        }
        catch (Exception e) {
            return this.getInitialContext();
        }
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }
}

