/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManagerOperations;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.openorb.io.HexPrintStream;
import org.openorb.net.Address;
import org.openorb.net.Transport;
import org.openorb.util.ExceptionTool;
import org.openorb.util.NamingUtils;

public abstract class AbstractAddress
implements Address,
Cloneable {
    private TargetAddress m_key_addr;
    private TargetAddress m_profile_addr;
    private TargetAddress m_reference_addr;
    private PolicyManagerOperations m_policies;
    private TaggedComponent[] m_components;
    private Object[] m_component_data;
    private int m_from_this_profile;
    private Constructor m_ctor = null;
    private Object[] m_args = null;
    private short m_priority = 0;

    protected void set_ior(IOR ior, int selected_profile) {
        if (ior != null) {
            this.m_reference_addr = new TargetAddress();
            this.m_reference_addr.ior(new IORAddressingInfo(selected_profile, ior));
            this.m_profile_addr = new TargetAddress();
            this.m_profile_addr.profile(ior.profiles[selected_profile]);
        }
    }

    protected void set_oid(byte[] oid) {
        if (oid != null) {
            this.m_key_addr = new TargetAddress();
            this.m_key_addr.object_key(oid);
        }
    }

    protected void set_policies(PolicyManagerOperations policies) {
        this.m_policies = policies;
    }

    protected void set_components(TaggedComponent[] components, int fromThisProfile) {
        this.m_components = components;
        this.m_from_this_profile = fromThisProfile;
        this.m_component_data = new Object[components.length];
    }

    public TargetAddress getTargetAddress(short adressingDisposition) {
        switch (adressingDisposition) {
            case 2: {
                if (this.m_reference_addr == null) break;
                return this.m_reference_addr;
            }
            case 1: {
                if (this.m_profile_addr == null) break;
                return this.m_profile_addr;
            }
            case 0: {
                if (this.m_key_addr == null) break;
                return this.m_key_addr;
            }
        }
        throw new NO_IMPLEMENT(0, CompletionStatus.COMPLETED_NO);
    }

    public Policy[] get_target_policies(int[] ts) {
        if (this.m_policies == null) {
            return new Policy[0];
        }
        return this.m_policies.get_policy_overrides(ts);
    }

    public TaggedComponent[] get_components() {
        if (this.m_components == null) {
            return new TaggedComponent[0];
        }
        return this.m_components;
    }

    public int get_profile_components() {
        return this.m_from_this_profile;
    }

    public TaggedComponent[] get_components(int tag) {
        if (this.m_components == null) {
            return new TaggedComponent[0];
        }
        int cnt = 0;
        int i = 0;
        while (i < this.m_components.length) {
            if (this.m_components[i].tag == tag) {
                ++cnt;
            }
            ++i;
        }
        TaggedComponent[] ret = new TaggedComponent[cnt];
        int i2 = this.m_components.length - 1;
        while (i2 >= 0 && cnt > 0) {
            if (this.m_components[i2].tag == tag) {
                ret[--cnt] = this.m_components[i2];
            }
            --i2;
        }
        return ret;
    }

    public TaggedComponent get_component(int idx) {
        if (this.m_components == null || idx < 0 || idx >= this.m_components.length) {
            throw new IndexOutOfBoundsException("No component at that index");
        }
        return this.m_components[idx];
    }

    public Object get_component_data(int idx) {
        if (this.m_components == null || idx < 0 || idx >= this.m_components.length) {
            throw new IndexOutOfBoundsException("No component at that index");
        }
        return this.m_component_data[idx];
    }

    public void set_component_data(int idx, Object obj) {
        if (this.m_components == null || idx < 0 || idx >= this.m_components.length) {
            throw new IndexOutOfBoundsException("No component at that index");
        }
        this.m_component_data[idx] = obj;
    }

    public void setTransportConstructor(Constructor ctor, Object[] args) {
        this.m_ctor = ctor;
        this.m_args = args;
    }

    public Transport createTransport() {
        try {
            return (Transport)this.m_ctor.newInstance(this.m_args);
        }
        catch (Exception ex) {
            throw ExceptionTool.initCause(new INTERNAL("AbstractAddress::createTransport: Exception during creation of new Transport instance (" + ex + ")"), (Throwable)ex);
        }
    }

    public short getPriority() {
        return this.m_priority;
    }

    public short getPriority(short mask) {
        return (short)(this.m_priority & mask);
    }

    public void setPriority(short priority) {
        this.m_priority = (short)(priority & 0xFFF);
    }

    public short setPriority(short priority, short mask) {
        this.m_priority = (short)(this.m_priority & ~mask | priority & 0xFFF & mask);
        return this.m_priority;
    }

    public String getObjectKeyString() {
        byte[] obj_key = this.m_key_addr.object_key();
        try {
            String str = new String(obj_key, "UTF-8");
            return NamingUtils.encodeRFC2396(str);
        }
        catch (UnsupportedEncodingException ex) {
            throw new CascadingRuntimeException("Encoding is not supported ", (Throwable)ex);
        }
    }

    public String getObjectKeyDescription() {
        String oks = this.getObjectKeyString();
        if (oks.indexOf("%") < 0) {
            return "Corbaloc Object Key: " + oks + "\n";
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        HexPrintStream hps = new HexPrintStream(os, 2);
        PrintStream ps = new PrintStream(os);
        byte[] obj_key = this.m_key_addr.object_key();
        if (obj_key[0] != 0 || obj_key[1] != 79 || obj_key[2] != 79) {
            ps.println("Non OpenORB Object Key:");
        } else if ((obj_key[3] & 1) == 0) {
            ps.println("OpenORB Persistent Object Key:");
        } else {
            ps.println("OpenORB Nonpersistent Object Key:");
        }
        ps.flush();
        try {
            hps.write(obj_key);
            hps.flush();
        }
        catch (IOException ex) {
            throw new CascadingRuntimeException("IOException during write or flush", (Throwable)ex);
        }
        return os.toString();
    }

    public int hashCode() {
        byte[] oid = this.m_key_addr.object_key();
        int hash = 0;
        int i = 0;
        while (i < oid.length) {
            hash = 311 * hash + oid[i];
            ++i;
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Address) || this.hashCode() != obj.hashCode()) {
            return false;
        }
        if (!(obj instanceof AbstractAddress)) {
            return false;
        }
        AbstractAddress aa2 = (AbstractAddress)obj;
        if (this.m_key_addr != aa2.m_key_addr && !Arrays.equals(this.m_key_addr.object_key(), aa2.m_key_addr.object_key())) {
            return false;
        }
        aa2.m_key_addr = this.m_key_addr;
        if (!this.m_ctor.equals(aa2.m_ctor) || this.m_args.length != aa2.m_args.length) {
            return false;
        }
        int i = 0;
        while (i < this.m_args.length) {
            if ((this.m_args[i] instanceof String || this.m_args[i] instanceof Number) && !this.m_args[i].equals(aa2.m_args[i])) {
                return false;
            }
            ++i;
        }
        if (this.m_components.length != aa2.m_components.length) {
            return false;
        }
        if (this.m_components != aa2.m_components) {
            boolean[] foundJ = new boolean[this.m_components.length];
            int i2 = 0;
            while (i2 < this.m_components.length) {
                boolean foundI = false;
                int j = 0;
                while (j < this.m_components.length) {
                    if (this.m_components[i2] == this.m_components[j] || this.m_components[i2].tag == aa2.m_components[j].tag && Arrays.equals(this.m_components[i2].component_data, aa2.m_components[j].component_data)) {
                        aa2.m_components[j] = this.m_components[i2];
                        foundJ[j] = true;
                        foundI = true;
                        break;
                    }
                    ++j;
                }
                if (!foundI) {
                    return false;
                }
                ++i2;
            }
            int i3 = 0;
            while (i3 < foundJ.length) {
                if (!foundJ[i3]) {
                    return false;
                }
                ++i3;
            }
        }
        return true;
    }
}

