/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.AbstractComboBox;
import com.jidesoft.combobox.ButtonPopupPanel;
import com.jidesoft.combobox.d;
import com.jidesoft.swing.PartialLineBorder;
import com.jidesoft.swing.SearchableUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontChooserPanel
extends ButtonPopupPanel {
    protected JLabel _previewLabel;
    protected JComboBox _fontNameComboBox;
    protected JSpinner _sizeSpinner;
    protected JCheckBox _boldCheckBox;
    protected JCheckBox _italicCheckBox;
    private String l;
    protected ComboBoxModel _fontNameComboBoxModel;

    public FontChooserPanel() {
        this.initComponents();
        this.installListeners();
    }

    public FontChooserPanel(Action action, Action action2) {
        super(action, action2);
        this.initComponents();
        this.installListeners();
    }

    protected void installListeners() {
        this._fontNameComboBoxModel = this.createFontNameComboBoxModel();
        this._fontNameComboBox.setModel(this._fontNameComboBoxModel);
        this._fontNameComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontChooserPanel.this._previewLabel.setFont(FontChooserPanel.this.getSelectedFont());
            }
        });
        this._sizeSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FontChooserPanel.this._previewLabel.setFont(FontChooserPanel.this.getSelectedFont());
            }
        });
        this._boldCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontChooserPanel.this._previewLabel.setFont(FontChooserPanel.this.getSelectedFont());
            }
        });
        this._italicCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontChooserPanel.this._previewLabel.setFont(FontChooserPanel.this.getSelectedFont());
            }
        });
        this._previewLabel.setFont(this.getSelectedFont());
    }

    protected DefaultComboBoxModel createFontNameComboBoxModel() {
        return new DefaultComboBoxModel<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
    }

    public ComboBoxModel getFontNameComboBoxModel() {
        return this._fontNameComboBoxModel;
    }

    public void setFontNameComboBoxModel(ComboBoxModel comboBoxModel) {
        block3: {
            JComboBox jComboBox;
            block2: {
                this._fontNameComboBoxModel = comboBoxModel;
                jComboBox = this._fontNameComboBox;
                if (AbstractComboBox.A != 0) break block2;
                if (jComboBox == null) break block3;
                jComboBox = this._fontNameComboBox;
            }
            jComboBox.setModel(comboBoxModel);
        }
    }

    protected void initComponents() {
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        jPanel.add(this.createPreviewPanel());
        jPanel.add((Component)this.createFontChooserPanel(), "Last");
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new BorderLayout());
        this.add(jPanel);
        this.add(this.createButtonPanel(4), "Last");
        this.setDefaultFocusComponent(this._fontNameComboBox);
    }

    protected JComponent createFontChooserPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this._fontNameComboBox = new JComboBox();
        SearchableUtils.installSearchable((JComboBox)this._fontNameComboBox);
        this._sizeSpinner = new JSpinner(new SpinnerNumberModel(10, 1, 100, 1));
        this._boldCheckBox = new JCheckBox(this.getResourceString("FontChooser.Bold.text"));
        this._boldCheckBox.setMnemonic(this.getResourceString("FontChooser.Bold.mnemonic").charAt(0));
        this._italicCheckBox = new JCheckBox(this.getResourceString("FontChooser.Italic.text"));
        this._italicCheckBox.setMnemonic(this.getResourceString("FontChooser.Italic.mnemonic").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 0, 3, 6);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(this.getResourceString("FontChooser.Font.text"));
        jLabel.setDisplayedMnemonic(this.getResourceString("FontChooser.Font.mnemonic").charAt(0));
        jLabel.setLabelFor(this._fontNameComboBox);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        JLabel jLabel2 = new JLabel(this.getResourceString("FontChooser.Size.text"));
        jLabel2.setDisplayedMnemonic(this.getResourceString("FontChooser.Size.mnemonic").charAt(0));
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jLabel2.setLabelFor(this._sizeSpinner);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)new JLabel(this.getResourceString("FontChooser.Style.text")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this._fontNameComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this._sizeSpinner, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 0, 0));
        jPanel2.add(this._boldCheckBox);
        jPanel2.add(this._italicCheckBox);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    protected JComponent createPreviewPanel() {
        this.l = "ABCDEFabcdef 012345";
        this._previewLabel = new JLabel(this.l);
        this._previewLabel.setHorizontalAlignment(0);
        this._previewLabel.setVerticalAlignment(0);
        this._previewLabel.setPreferredSize(new Dimension(200, 60));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this._previewLabel);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder((Border)new PartialLineBorder(Color.gray, 1, true), " " + this.getResourceString("FontChooser.Preview.text") + " ", 4, 2), BorderFactory.createEmptyBorder(2, 4, 4, 4)));
        return jPanel;
    }

    public Font getSelectedFont() {
        block3: {
            Object object;
            block2: {
                Object object2;
                object = object2 = this.getSelectedObject();
                if (AbstractComboBox.A != 0) break block2;
                if (!(object instanceof Font)) break block3;
                object = object2;
            }
            return (Font)object;
        }
        return null;
    }

    public void setSelectedFont(Font font) {
        this.setSelectedObject(font);
    }

    public Object getSelectedObject() {
        return new Font((String)this._fontNameComboBox.getSelectedItem(), (this._boldCheckBox.isSelected() ? 1 : 0) | (this._italicCheckBox.isSelected() ? 2 : 0), (Integer)this._sizeSpinner.getValue());
    }

    public void setSelectedObject(Object object) {
        block6: {
            Object object2;
            int n;
            block5: {
                n = AbstractComboBox.A;
                super.setSelectedObject(object);
                object2 = object;
                if (n != 0) break block5;
                if (!(object2 instanceof Font)) break block6;
                object2 = object;
            }
            Font font = (Font)object2;
            this._fontNameComboBox.setSelectedItem(font.getName());
            this._sizeSpinner.setValue(new Integer(font.getSize()));
            boolean bl = font.getStyle() & 1;
            if (n == 0) {
                bl = bl;
            }
            this._boldCheckBox.setSelected(bl);
            boolean bl2 = font.getStyle() & 2;
            if (n == 0) {
                bl2 = bl2;
            }
            this._italicCheckBox.setSelected(bl2);
        }
    }

    public String getPreviewText() {
        return this.l;
    }

    public void setPreviewText(String string) {
        block3: {
            JLabel jLabel;
            block2: {
                this.l = string;
                jLabel = this._previewLabel;
                if (AbstractComboBox.A != 0) break block2;
                if (jLabel == null) break block3;
                jLabel = this._previewLabel;
            }
            jLabel.setText(this.l);
        }
    }

    protected String getResourceString(String string) {
        return d.getResourceBundle(Locale.getDefault()).getString(string);
    }
}

