/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.openarchitectureware.BuildJob;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.ProjectAnalyzer;
import org.openarchitectureware.internal.EmfToolsLog;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmfToolsPlugin
extends AbstractUIPlugin {
    private static EmfToolsPlugin plugin;
    private final Map<IJavaProject, ProjectAnalyzer> projectAnalyzerCache = new HashMap<IJavaProject, ProjectAnalyzer>();
    public static boolean trace;
    private final IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                if (event.getDelta() == null) {
                    return;
                }
                final HashSet changedProjects = new HashSet();
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if ((EmfToolsPlugin.this.isEcoreFile(delta.getResource()) || EmfToolsPlugin.this.isJarFile(delta.getResource())) && JavaCore.create((IProject)delta.getResource().getProject()).isOnClasspath(delta.getResource())) {
                            changedProjects.add(delta.getResource().getProject());
                        }
                        return true;
                    }
                });
                EmfToolsPlugin.this.analyzeAndRebuildProjects(changedProjects);
            }
            catch (CoreException e) {
                EmfToolsLog.logError(e);
            }
        }
    };
    private final IElementChangedListener classpathListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            HashSet<IProject> projects = new HashSet<IProject>();
            this.collectChangedProjects(event.getDelta(), projects);
            EmfToolsPlugin.this.analyzeAndRebuildProjects(projects);
        }

        private void collectChangedProjects(IJavaElementDelta delta, Set<IProject> projects) {
            IJavaProject javaProject;
            if (((delta.getFlags() & 0x40) != 0 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 0x20000) != 0) && (javaProject = delta.getElement().getJavaProject()) != null) {
                projects.add(javaProject.getProject());
            }
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta d = iJavaElementDeltaArray[n2];
                this.collectChangedProjects(d, projects);
                ++n2;
            }
        }
    };

    static {
        trace = false;
        String value = Platform.getDebugOption((String)"org.openarchitectureware.emftools/trace");
        if (value != null && value.equals("true")) {
            trace = true;
        }
    }

    public ProjectAnalyzer getProjectAnalyzer(IProject p) {
        IJavaProject jp = JavaCore.create((IProject)p);
        if (jp == null || !jp.exists()) {
            return null;
        }
        ProjectAnalyzer analyzer = this.projectAnalyzerCache.get(jp);
        if (analyzer == null) {
            analyzer = new ProjectAnalyzer(jp);
            this.projectAnalyzerCache.put(jp, analyzer);
        }
        return analyzer;
    }

    public EmfToolsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectAnalyzer pa;
            IProject p = iProjectArray[n2];
            if (OawPlugin.getOawModelManager().findProject((IResource)p) != null && (pa = this.getProjectAnalyzer(p)) != null && pa.getState() != 2) {
                pa.schedule();
            }
            ++n2;
        }
        workspace.addResourceChangeListener(this.resourceListener);
        JavaCore.addElementChangedListener((IElementChangedListener)this.classpathListener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.classpathListener);
        this.projectAnalyzerCache.clear();
    }

    public EPackage[] getMetamodelsForProject(IJavaProject project) {
        HashSet<String> visited = new HashSet<String>();
        return this.getMetamodelsForProjectInternal(project, visited);
    }

    /*
     * Unable to fully structure code
     */
    private EPackage[] getMetamodelsForProjectInternal(IJavaProject project, Set<String> visited) {
        if (visited.contains(project.getProject().getName())) {
            return new EPackage[0];
        }
        visited.add(project.getProject().getName());
        projectAnalyzer = this.getProjectAnalyzer(project.getProject());
        if (projectAnalyzer != null) ** GOTO lbl15
        return new EPackage[0];
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(500L);
                if (!EmfToolsPlugin.trace) continue;
                System.out.println("Waiting 500ms for ProjectAnalyzer of project " + project.getProject().getName() + " to finish.");
                continue;
            }
            catch (InterruptedException e) {
                EmfToolsLog.logError(e);
            }
lbl15:
            // 4 sources

            ** while (projectAnalyzer.getState() == 4 || projectAnalyzer.getState() == 2)
        }
lbl16:
        // 1 sources

        packages = new HashMap<String, EPackage>(projectAnalyzer.getNamedEPackageMap());
        try {
            var8_6 = project.getProject().getReferencedProjects();
            var7_7 = var8_6.length;
            var6_8 = 0;
            while (var6_8 < var7_7) {
                p = var8_6[var6_8];
                jp = JavaCore.create((IProject)p);
                var14_16 = ps = this.getMetamodelsForProjectInternal(jp, visited);
                var13_15 = ps.length;
                var12_14 = 0;
                while (var12_14 < var13_15) {
                    package1 = var14_16[var12_14];
                    if (!packages.containsKey(package1.getNsURI())) {
                        packages.put(package1.getNsURI(), package1);
                    }
                    ++var12_14;
                }
                ++var6_8;
            }
        }
        catch (CoreException e) {
            EmfToolsLog.logError(e);
        }
        return packages.values().toArray(new EPackage[packages.values().size()]);
    }

    public static EmfToolsPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)EmfToolsPlugin.getId(), (String)path);
    }

    public static String getId() {
        return EmfToolsPlugin.getDefault().getBundle().getSymbolicName();
    }

    protected boolean isEcoreFile(IResource f) {
        return f instanceof IFile && !f.isDerived() && "ecore".equalsIgnoreCase(f.getFileExtension());
    }

    protected boolean isJarFile(IResource f) {
        return f instanceof IFile && !f.isDerived() && "jar".equalsIgnoreCase(f.getFileExtension());
    }

    private void collectReferencingOawProjects(IProject project, Map<String, IProject> referencingProjects, Set<String> visited) {
        if (visited.contains(project.getName())) {
            return;
        }
        visited.add(project.getName());
        IProject[] iProjectArray = project.getReferencingProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (OawPlugin.getOawModelManager().findProject((IResource)p) != null) {
                referencingProjects.put(p.getName(), p);
            }
            this.collectReferencingOawProjects(p, referencingProjects, visited);
            ++n2;
        }
    }

    private void analyzeAndRebuildProjects(Set<IProject> projects) {
        HashMap<String, IProject> referencingProjects = new HashMap<String, IProject>();
        HashSet<String> visited = new HashSet<String>();
        for (IProject p : projects) {
            ProjectAnalyzer pa = this.getProjectAnalyzer(p);
            if (pa != null && pa.getState() != 2) {
                pa.schedule();
            }
            this.collectReferencingOawProjects(p, referencingProjects, visited);
        }
        ArrayList relevantProjects = new ArrayList(referencingProjects.values());
        relevantProjects.removeAll(projects);
        for (IProject refProject : relevantProjects) {
            new BuildJob(refProject).schedule();
        }
    }
}

