/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.openarchitectureware.internal.OawLog;

public class NewOAWResourcePage
extends WizardNewFileCreationPage {
    private final String extension;
    private String initialContents;
    private String charSet;

    public NewOAWResourcePage(String pageName, IStructuredSelection selection, String initial, String extension, String initialContents) {
        super(pageName, selection);
        this.setFileName(initial);
        this.extension = extension;
        this.initialContents = initialContents;
    }

    public NewOAWResourcePage(String pageName, IStructuredSelection selection, String initial, String extension, String initialContents, String charSet) {
        this(pageName, selection, initial, extension, initialContents);
        this.charSet = charSet;
    }

    public IFile createNewFile() {
        try {
            IFile file = super.createNewFile();
            if (file != null && this.charSet != null) {
                file.setCharset(this.charSet, (IProgressMonitor)new NullProgressMonitor());
            }
            return file;
        }
        catch (CoreException e) {
            OawLog.logError("Core exception", e);
            return null;
        }
    }

    public String getErrorMessage() {
        if (!this.getFileName().endsWith("." + this.extension)) {
            return "extension must be ." + this.extension;
        }
        return null;
    }

    protected InputStream getInitialContents() {
        if (this.initialContents == null) {
            this.initialContents = "";
        }
        return new ByteArrayInputStream(this.initialContents.getBytes());
    }
}

