/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.editor.search.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.openarchitectureware.core.action.SelectionDispatchAction;
import org.openarchitectureware.editor.AbstractOawEditor;
import org.openarchitectureware.editor.search.actions.FindDeclarationsAction;

public class DeclarationsSearchGroup
extends ActionGroup {
    private final IWorkbenchSite site;
    private IActionBars actionBars;
    private final String groupId;
    private SelectionDispatchAction findDeclarationsAction;

    public DeclarationsSearchGroup(IWorkbenchSite site) {
        this.site = site;
        this.groupId = "group.search";
        this.findDeclarationsAction = new FindDeclarationsAction(site);
        this.findDeclarationsAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.declarations.in.workspace");
        ISelectionProvider provider = site.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.findDeclarationsAction, provider, selection);
    }

    protected DeclarationsSearchGroup(AbstractOawEditor editor) {
        Assert.isNotNull((Object)((Object)editor));
        this.site = editor.getSite();
        this.groupId = "group.find";
        this.findDeclarationsAction = new FindDeclarationsAction(editor);
        this.findDeclarationsAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.declarations.in.workspace");
        editor.setAction("SearchDeclarationsInWorkspace", (IAction)this.findDeclarationsAction);
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.actionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager menuManager = new MenuManager("Dec&larations", "group.search");
        this.addAction((IAction)this.findDeclarationsAction, (IMenuManager)menuManager);
        menuManager.add((IContributionItem)new Separator());
        if (!menuManager.isEmpty()) {
            manager.appendToGroup(this.groupId, (IContributionItem)menuManager);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.site.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.findDeclarationsAction, provider);
        }
        this.findDeclarationsAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.DeclarationsInWorkspace", (IAction)this.findDeclarationsAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

