/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.properties;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.openarchitectureware.OawPlugin;
import org.openarchitectureware.core.IOawProject;
import org.openarchitectureware.core.metamodel.Contributor;
import org.openarchitectureware.core.metamodel.MetamodelContributorRegistry;
import org.openarchitectureware.internal.OawLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelContributorsPropertyAndPreferencePage
extends PropertyAndPreferencePage {
    private Button downButton;
    private Button upButton;
    private CheckboxTableViewer checkboxTableViewer;
    private IPreferenceStore prefStore;
    private LinkedList<Contributor> availableMetamodelContributors;
    private Table table;

    private Collection<Contributor> getEnabledMetamodelContributors() {
        Map<String, Contributor> availableMetamodelContributors = MetamodelContributorRegistry.getRegisteredMetamodelContributors();
        this.prefStore = this.getPreferenceStore();
        MetamodelContributorsPropertyAndPreferencePage.fixMetamodelContributorPreferences(this.prefStore);
        String rawString = this.prefStore.getString("metamodelContributor");
        LinkedList<Contributor> result = new LinkedList<Contributor>();
        if (this.isNotEmpty(rawString)) {
            String[] selected;
            String[] stringArray = selected = rawString.split(",");
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                String metaModelContributorClassName = stringArray[n2];
                Contributor contributor = availableMetamodelContributors.get(metaModelContributorClassName);
                result.add(contributor);
                ++n2;
            }
        }
        return result;
    }

    private LinkedList<Contributor> getMetamodelContributors() {
        Map<String, Contributor> availableMetamodelContributors = MetamodelContributorRegistry.getRegisteredMetamodelContributors();
        this.prefStore = this.getPreferenceStore();
        MetamodelContributorsPropertyAndPreferencePage.fixMetamodelContributorPreferences(this.prefStore);
        String rawString = this.prefStore.getString("metamodelContributor");
        LinkedList<Contributor> result = new LinkedList<Contributor>();
        if (this.isNotEmpty(rawString)) {
            String[] selected;
            String[] stringArray = selected = rawString.split(",");
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                String metaModelContributorClassName = stringArray[n2];
                Contributor contributor = availableMetamodelContributors.get(metaModelContributorClassName);
                result.add(contributor);
                ++n2;
            }
        }
        for (Contributor contributor : availableMetamodelContributors.values()) {
            if (result.contains(contributor)) continue;
            result.add(contributor);
        }
        return result;
    }

    private static void fixMetamodelContributorPreferences(IPreferenceStore prefStore) {
        String metamodelContr = prefStore.getString("metamodelContributor");
        if (metamodelContr.indexOf("openarchitecturware") > 0) {
            metamodelContr = metamodelContr.replace("openarchitecturware", "openarchitectureware");
            prefStore.setValue("metamodelContributor", metamodelContr);
        }
    }

    private boolean isNotEmpty(String rawString) {
        return rawString != null && !rawString.equals("");
    }

    protected IPreferenceStore doGetPreferenceStore() {
        ScopedPreferenceStore store;
        if (this.isProjectPreferencePage()) {
            IProject project = this.getProject();
            store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), OawPlugin.getId());
        } else {
            store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), OawPlugin.getId());
        }
        return store;
    }

    private void updateButtonStates() {
        int index = this.table.getSelectionIndex();
        if (index == 0) {
            this.upButton.setEnabled(false);
        } else {
            this.upButton.setEnabled(true);
        }
        if (index >= this.checkboxTableViewer.getTable().getItemCount() - 1) {
            this.downButton.setEnabled(false);
        } else {
            this.downButton.setEnabled(true);
        }
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        container.setLayout((Layout)gridLayout);
        Label activatedMetamodelContributorsLabel = new Label(container, 0);
        activatedMetamodelContributorsLabel.setText("&Activated metamodel contributors:");
        new Label(container, 0);
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2048);
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table = this.checkboxTableViewer.getTable();
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetamodelContributorsPropertyAndPreferencePage.this.updateButtonStates();
            }
        });
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        GridLayout gridLayout_1 = new GridLayout();
        composite.setLayout((Layout)gridLayout_1);
        this.upButton = new Button(composite, 0);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection;
                Object firstElement;
                ISelection selection = MetamodelContributorsPropertyAndPreferencePage.this.checkboxTableViewer.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof Contributor) {
                    Contributor contributor = (Contributor)firstElement;
                    int index = MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.indexOf(contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.remove(contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.add(index - 1, contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.checkboxTableViewer.refresh();
                }
                MetamodelContributorsPropertyAndPreferencePage.this.updateButtonStates();
            }
        });
        GridData gridData_1 = new GridData(4, 0x1000000, false, false);
        gridData_1.widthHint = 75;
        this.upButton.setLayoutData((Object)gridData_1);
        this.upButton.setText("&Up");
        this.downButton = new Button(composite, 0);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection;
                Object firstElement;
                ISelection selection = MetamodelContributorsPropertyAndPreferencePage.this.checkboxTableViewer.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof Contributor) {
                    Contributor contributor = (Contributor)firstElement;
                    int index = MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.indexOf(contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.remove(contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.add(index + 1, contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.checkboxTableViewer.refresh();
                }
                MetamodelContributorsPropertyAndPreferencePage.this.updateButtonStates();
            }
        });
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = 75;
        this.downButton.setLayoutData((Object)gridData);
        this.downButton.setText("&Down");
        this.setupData();
        return container;
    }

    private void setupData() {
        this.availableMetamodelContributors = this.getMetamodelContributors();
        this.checkboxTableViewer.setInput(this.availableMetamodelContributors);
        Collection<Contributor> enabledMetamodelContributors = this.getEnabledMetamodelContributors();
        this.checkboxTableViewer.setCheckedElements(enabledMetamodelContributors.toArray());
    }

    protected String getPreferencePageID() {
        return "org.openarchitectureware.core.properties.MetamodelContributorsPropertyPage";
    }

    protected String getPropertyPageID() {
        return "org.openarchitectureware.core.properties.MetamodelContributorsPropertyPage";
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        return preferenceStore.getBoolean("project.specific.metamodel");
    }

    public boolean performOk() {
        if (this.isProjectPreferencePage()) {
            this.prefStore.setValue("project.specific.metamodel", this.useProjectSettings());
        }
        this.prefStore.setValue("metamodelContributor", this.createStoreString());
        try {
            ((ScopedPreferenceStore)this.prefStore).save();
        }
        catch (IOException e1) {
            OawLog.logError(e1);
        }
        if (this.isProjectPreferencePage()) {
            final IProject project = this.getProject();
            Job job = new Job("Analyzing " + project.getName() + " ..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                IOawProject p = OawPlugin.getOawModelManager().findProject((IResource)project);
                                if (p != null) {
                                    monitor.beginTask("...", p.getRegisteredResources().length);
                                    p.analyze(monitor);
                                    monitor.done();
                                }
                            }
                        }.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        OawLog.logError(e);
                    }
                    catch (InterruptedException e) {
                        OawLog.logError(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            Job job = new Job("Analyzing all oAW projects..."){

                protected IStatus run(IProgressMonitor monitor) {
                    OawPlugin.getOawModelManager().analyze(monitor);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return super.performOk();
    }

    private String createStoreString() {
        Object[] checkedElements = this.checkboxTableViewer.getCheckedElements();
        String result = "";
        int i = 0;
        while (i < checkedElements.length) {
            Object object = checkedElements[i];
            if (object instanceof Contributor) {
                Contributor contributor = (Contributor)object;
                String className = contributor.getClassName();
                result = String.valueOf(result) + className;
            }
            if (i < checkedElements.length - 1) {
                result = String.valueOf(result) + ",";
            }
            ++i;
        }
        return result;
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Contributor) {
                Contributor contributor = (Contributor)element;
                return contributor.getDisplayName();
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

