/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.metamodel.jdt.javabean;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.openarchitectureware.core.metamodel.jdt.JdtTypeStrategy;
import org.openarchitectureware.workflow.util.StringHelper;

public class JdtJavaBeanTypeStrategy
implements JdtTypeStrategy {
    public JdtJavaBeanTypeStrategy(IJavaProject project) {
    }

    public IType[] getSuperTypes(IType type) throws JavaModelException {
        ITypeHierarchy hier = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType[] ifs = hier.getSuperInterfaces(type);
        IType st = hier.getSuperclass(type);
        if (st == null) {
            return ifs;
        }
        IType[] result = new IType[ifs.length + 1];
        System.arraycopy(ifs, 0, result, 0, ifs.length);
        result[ifs.length] = st;
        return result;
    }

    public boolean isAssignable(IType toAssigTo, IType assignable) throws JavaModelException {
        return assignable.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()).contains(toAssigTo);
    }

    public boolean isGetter(IMethod method) {
        int flags;
        try {
            flags = method.getFlags();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        String name = method.getElementName();
        return !Flags.isStatic((int)flags) && method.getParameterTypes().length == 0 && (name.startsWith("get") || name.startsWith("is"));
    }

    public String getterToProperty(String elementName) {
        String propName = null;
        if (elementName.startsWith("get")) {
            propName = elementName.substring(3, elementName.length());
        } else if (elementName.startsWith("is")) {
            propName = elementName.substring(2, elementName.length());
        } else {
            return elementName;
        }
        if (propName.length() == 1 || propName.matches("\\p{Upper}\\p{Lower}.*")) {
            propName = StringHelper.firstLower((String)propName);
            return propName;
        }
        if (propName.length() > 1) {
            return propName;
        }
        return elementName;
    }

    public boolean isConstant(IField field) {
        try {
            return field.isEnumConstant() || field.getDeclaringType().isInterface() || Flags.isPublic((int)field.getFlags()) && Flags.isFinal((int)field.getFlags()) && Flags.isStatic((int)field.getFlags());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public boolean isOperation(IMethod method) {
        if (!this.isGetter(method)) {
            try {
                int flags = method.getFlags();
                if (!Flags.isStatic((int)flags)) {
                    return true;
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    public String propertyName(IMethod method) {
        return this.getterToProperty(method.getElementName());
    }

    public String getPropertiesInnerType(IMethod method) {
        return null;
    }

    public String propertyName(IField field) {
        return field.getElementName();
    }
}

