/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.core.action;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public abstract class SelectionDispatchAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite site;
    private ISelectionProvider specialSelectionProvider;

    protected SelectionDispatchAction(IWorkbenchSite site) {
        Assert.isNotNull((Object)site);
        this.site = site;
    }

    public IWorkbenchSite getSite() {
        return this.site;
    }

    public ISelection getSelection() {
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null) {
            return selectionProvider.getSelection();
        }
        return null;
    }

    public Shell getShell() {
        return this.site.getShell();
    }

    public ISelectionProvider getSelectionProvider() {
        if (this.specialSelectionProvider != null) {
            return this.specialSelectionProvider;
        }
        return this.site.getSelectionProvider();
    }

    public void setSpecialSelectionProvider(ISelectionProvider provider) {
        this.specialSelectionProvider = provider;
    }

    public void update(ISelection selection) {
        this.dispatchSelectionChanged(selection);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.selectionChanged((ISelection)selection);
    }

    public void run(IStructuredSelection selection) {
        this.run((ISelection)selection);
    }

    public void selectionChanged(ITextSelection selection) {
        this.selectionChanged((ISelection)selection);
    }

    public void run(ITextSelection selection) {
        this.run((ISelection)selection);
    }

    public void selectionChanged(ISelection selection) {
        this.setEnabled(false);
    }

    public void run(ISelection selection) {
    }

    public void run() {
        this.dispatchRun(this.getSelection());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.dispatchSelectionChanged(event.getSelection());
    }

    private void dispatchSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.selectionChanged((ITextSelection)selection);
        } else {
            this.selectionChanged(selection);
        }
    }

    private void dispatchRun(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.run((ITextSelection)selection);
        } else {
            this.run(selection);
        }
    }
}

