/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.console;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListenerDelegate;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;
import org.openarchitectureware.console.OawConsoleHyperLink;

public class OawFilenameConsoleTracker
implements IPatternMatchListenerDelegate {
    Pattern fileNamePattern = Pattern.compile("\\S*[/\\.]\\S*(:\\d+)*");
    Pattern lineNumber = Pattern.compile(":(\\d+)");
    private TextConsole fConsole;

    public void matchFound(PatternMatchEvent event) {
        try {
            int offset = event.getOffset();
            int length = event.getLength();
            TextConsole console = this.getConsole();
            String oawFileId = console.getDocument().get(offset, length);
            Matcher m = this.fileNamePattern.matcher(oawFileId);
            if (m.find()) {
                String fileName = m.group();
                String linenumberString = "";
                int linenumber = -1;
                Matcher ml = this.lineNumber.matcher(m.group());
                if (ml.find()) {
                    linenumberString = ml.group(1);
                    linenumber = Integer.parseInt(linenumberString);
                    fileName = ml.replaceAll("");
                } else {
                    linenumber = 1;
                }
                offset += m.start();
                length = m.end() - m.start();
                IPath location = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                Path path = new Path(fileName);
                int matchingFirstSegments = path.matchingFirstSegments(location);
                IPath removeFirstSegments = path.removeFirstSegments(matchingFirstSegments);
                IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(removeFirstSegments);
                if (res != null) {
                    OawConsoleHyperLink link = new OawConsoleHyperLink(res, linenumber);
                    this.getConsole().addHyperlink((IHyperlink)link, offset, length);
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (RuntimeException runtimeException) {}
    }

    public void connect(TextConsole console) {
        this.fConsole = console;
    }

    public void disconnect() {
        this.fConsole = null;
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }
}

