/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.net.URL;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbPresenter;
import org.netbeans.core.windows.BoundsConvertor;
import org.netbeans.core.windows.DeferredPerformer;
import org.netbeans.core.windows.LazyUpdater;
import org.netbeans.core.windows.MainWindow;
import org.netbeans.core.windows.StateManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.DesktopFrameTypeImpl;
import org.netbeans.core.windows.frames.DesktopPane;
import org.netbeans.core.windows.frames.FrameType;
import org.netbeans.core.windows.frames.FrameTypeEvent;
import org.netbeans.core.windows.frames.FrameTypeListener;
import org.netbeans.core.windows.frames.FrameTypeSupport;
import org.netbeans.core.windows.frames.InternalFrameTypeImpl;
import org.netbeans.core.windows.frames.LayoutResource;
import org.netbeans.core.windows.frames.MultiTabbedContainerImpl;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.frames.WindowTypesManager;
import org.netbeans.core.windows.util.DefaultReplacer;
import org.netbeans.core.windows.util.VersionSerializator;
import org.netbeans.core.windows.util.WindowUtils;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class ModeImpl
implements Comparable,
Mode,
FrameTypeListener,
ComponentListener,
DeferredPerformer.DeferredCommand,
StateManager.StateListener {
    static final long serialVersionUID = 2721445375634234372L;
    public static final ModeImpl SINGLE = new ModeImpl("SingleNewMode", null, null, false, null);
    public static final ModeImpl MULTI = new ModeImpl("MultiNewMode", null, null, false, null);
    public static final ModeImpl SPLIT = new ModeImpl("SplitNewMode", null, null, false, null);
    public static final String PROP_TOP_COMPONENTS = "topComponents";
    public static final String PROP_FRAME_INSTANCE = "frameInstance";
    public static final String PROP_CONTAINER_INSTANCE = "containerInstance";
    public static final String PROP_CONSTRAINTS = "containerInstance";
    public static final int PROPERTIES = 1;
    public static final int COMPONENTS = 2;
    public static final int COMPONENT_IDS = 4;
    public static final String NAMING_TYPE = "NamingType";
    public static final String BOTH_ONLY_COMP_NAME = "BothOnlyCompName";
    public static final String SDI_ONLY_COMP_NAME = "SDIOnlyCompName";
    public static final String MDI_ONLY_COMP_NAME = "MDIOnlyCompName";
    private URL icon;
    private Image iconImage;
    private String name;
    private String displayName;
    private String description;
    private Rectangle bounds;
    private boolean userDefined;
    private Workspace workspace;
    private String workspaceName;
    private TopComponentContainer tcc;
    private FrameType frame;
    private boolean active = false;
    private String containerType;
    private String frameType;
    private int frameTypeState = -1;
    private Object constraints;
    private Object currnetConstraints;
    private List ignoredTcList;
    private WeakHashMap closedComponents;
    private PropertyChangeSupport changeSupport;
    private boolean showing;
    private boolean deferredFocusRequest;
    private TopComponent compToReceiveFocus;
    private NameListener nameListener;
    private Rectangle relativeBounds;
    private HashMap areas;
    private static VersionSerializator serializationManager;
    private LazyUpdater updater;
    private boolean hidden = true;
    private String nameBundle;
    private String descriptionBundle;
    private boolean fromBundle;
    private boolean closeOnlyInMemory;
    private boolean boundsConverted;
    private String[] topComponentIds;
    private Set iconifiedShownTcs;
    private boolean isChanged = false;
    private boolean isValidForSaving = true;
    private Container origContentPane;
    private int pendingDockInto = 0;
    static /* synthetic */ Class class$org$netbeans$core$windows$ModeImpl;
    static /* synthetic */ Class class$org$openide$windows$TopComponent;
    static /* synthetic */ Class class$javax$swing$JDesktopPane;

    public ModeImpl(String name, String displayName, URL icon, int containerType, boolean userDefined, Workspace workspace) {
        this(name, displayName, icon, userDefined, workspace);
    }

    public ModeImpl(String name, String displayName, URL icon, boolean userDefined, Workspace workspace) {
        this.name = name;
        this.displayName = displayName;
        this.icon = icon;
        this.workspace = workspace;
        this.userDefined = userDefined;
        this.initialize();
    }

    public ModeImpl(Workspace workspace, ModeImpl original) {
        this(original.getName(), original.getDisplayNameXML(), original.getIconURL(), original.isUserDefined(), workspace);
        if (workspace.findMode(this.name) != null) {
            int i = 1;
            while (workspace.findMode(this.name = original.name + "_" + i++) != null) {
            }
        }
        this.fromBundle = original.isFromBundle();
        this.nameBundle = original.getNameBundle();
        this.setBounds(new Rectangle(original.bounds));
        this.setContainerType(original.getContainerType());
        this.setFrameType(original.getFrameType());
        WindowUtils.changeModeConstraints(this, original.constraints, true);
        ((WorkspaceImpl)workspace).addMode(this);
        TopComponent[] tcs = original.getTopComponents();
        int i = 0;
        while (i < tcs.length) {
            Object constr = original.tcc.getConstraints(tcs[i]);
            if (this.canDock(tcs[i]) && this.dockInto(tcs[i], constr)) {
                tcs[i].open(workspace);
            }
            ++i;
        }
    }

    private void initialize() {
        this.bounds = new Rectangle();
        this.changeSupport = new PropertyChangeSupport(this);
        StateManager stateManager = StateManager.getDefault();
        if ((stateManager.getState() & 1) == 0) {
            stateManager.addStateListener(this);
        }
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
        if (isChanged) {
            WindowManagerImpl.getInstance().postSaving();
        }
    }

    public boolean isValidForSaving() {
        return this.isValidForSaving;
    }

    public void setValidForSaving(boolean isValidForSaving) {
        this.isValidForSaving = isValidForSaving;
    }

    public void save() throws IOException {
        try {
            if (this.updater != null && this.isChanged() && this.isValidForSaving()) {
                this.updater.save();
            }
            Object var2_1 = null;
            if (this.isChanged()) {
                this.setChanged(false);
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.isChanged()) {
                this.setChanged(false);
            }
            throw throwable;
        }
    }

    public void updateBounds() {
        if (this.relativeBounds != null) {
            this.setRelativeBounds(this.relativeBounds);
        }
        Rectangle modeBounds = this.getBounds();
        if (this.areas != null && modeBounds != null) {
            Iterator it = this.areas.keySet().iterator();
            while (it.hasNext()) {
                TopComponentContainer.Area curArea = (TopComponentContainer.Area)this.areas.get(it.next());
                Rectangle relBounds = curArea.getRelativeBounds();
                if (relBounds == null) continue;
                Rectangle absBounds = new Rectangle();
                absBounds.x = relBounds.x * modeBounds.width / 100;
                absBounds.y = relBounds.y * modeBounds.height / 100;
                absBounds.width = relBounds.width * modeBounds.width / 100;
                absBounds.height = relBounds.height * modeBounds.height / 100;
                curArea.setBounds(absBounds);
                curArea.setRelativeBounds(null);
            }
        }
    }

    public void stateChanged(int state) {
        if ((state & 1) != 0) {
            StateManager.getDefault().removeStateListener(this);
            this.updateBounds();
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean canDock(TopComponent tc) {
        return this.tcc == null ? true : this.tcc.canAdd(new TopComponent[]{tc});
    }

    public boolean dockInto(TopComponent tc) {
        return this.dockInto(tc, null);
    }

    public boolean dockInto(TopComponent tc, Object constraints) {
        return this.dockInto(tc, constraints, Integer.MAX_VALUE);
    }

    public boolean dockInto(TopComponent tc, Object constraints, int orderWeight) {
        return this.doDockInto(tc, constraints, orderWeight, true);
    }

    public boolean dockIntoNoSelect(TopComponent tc) {
        return this.dockIntoNoSelect(tc, null);
    }

    public boolean dockIntoNoSelect(TopComponent tc, Object constraints) {
        return this.dockIntoNoSelect(tc, constraints, Integer.MAX_VALUE);
    }

    public boolean dockIntoNoSelect(TopComponent tc, Object constraints, int orderWeight) {
        return this.doDockInto(tc, constraints, orderWeight, false);
    }

    public boolean doDockInto(final TopComponent tc, final Object constraints, final int orderWeight, final boolean select) {
        if (!this.canDock(tc)) {
            return false;
        }
        this.ensureSectionLoaded(3);
        ++this.pendingDockInto;
        DeferredPerformer.getDefault().putRequest(new DeferredPerformer.DeferredCommand(){

            public void performCommand(DeferredPerformer.DeferredContext dc) {
                ModeImpl mi = (ModeImpl)ModeImpl.this.workspace.findMode(tc);
                boolean opened = WindowManagerImpl.findManager(tc).isOpened(ModeImpl.this.workspace);
                if (mi != null && !ModeImpl.this.equals(mi)) {
                    mi.release(tc);
                }
                if (opened) {
                    if (select && (ModeImpl.this.tcc == null || ModeImpl.this.tcc.containsTopComponent(tc))) {
                        ((WorkspaceImpl)ModeImpl.this.getWorkspace()).addToShownTcs(tc);
                    }
                    ModeImpl.this.updateBounds();
                    if (!ModeImpl.this.isBoundsSet()) {
                        ((WorkspaceImpl)ModeImpl.this.workspace).placeMode(ModeImpl.this, tc);
                    }
                    ClosedTCContext savedProps = ModeImpl.this.removeClosedComponent(tc);
                    WindowUtils.changeModeConstraints(ModeImpl.this, ModeImpl.this.constraints, true);
                    ModeImpl.this.addToContainer(tc, select, constraints == null && savedProps != null ? savedProps.constraints : constraints, orderWeight == Integer.MAX_VALUE && savedProps != null ? savedProps.orderWeight : orderWeight);
                    if (ModeImpl.this.workspace.equals(WindowManager.getDefault().getCurrentWorkspace())) {
                        ModeImpl.this.setVisible(true);
                    }
                } else {
                    ModeImpl.this.addClosedComponent(tc, constraints, orderWeight);
                }
                ModeImpl.this.changeSupport.firePropertyChange(ModeImpl.PROP_TOP_COMPONENTS, null, null);
                ModeImpl.this.pendingDockInto--;
            }
        }, new DeferredPerformer.DeferredContext(null, true));
        return true;
    }

    public int getPendingDockInto() {
        return this.pendingDockInto;
    }

    public void release(TopComponent tc) {
        WindowManagerImpl.getInstance();
        if (WindowManagerImpl.findManager(tc).isOpened(this.workspace)) {
            int left = 0;
            if (this.tcc != null) {
                left = this.tcc.removeTopComponent(tc);
            }
            if (left <= 0) {
                this.destroyFrame();
                this.destroyContainer();
            } else {
                this.updateNameListener();
            }
        } else {
            this.removeClosedComponent(tc);
        }
        this.changeSupport.firePropertyChange(PROP_TOP_COMPONENTS, null, null);
    }

    public void close(final TopComponent tc) {
        DeferredPerformer.getDefault().putRequest(new DeferredPerformer.DeferredCommand(){

            public void performCommand(DeferredPerformer.DeferredContext dc) {
                if (ModeImpl.this.tcc == null) {
                    return;
                }
                if (ModeImpl.this.tcc.containsTopComponent(tc)) {
                    Object constraints = ModeImpl.this.tcc.getConstraints(tc);
                    int orderWeight = ModeImpl.this.tcc.getOrderWeight(tc);
                    int left = ModeImpl.this.tcc.removeTopComponent(tc);
                    if (left <= 0) {
                        ModeImpl.this.destroyFrame();
                        ModeImpl.this.destroyContainer();
                    } else {
                        ModeImpl.this.updateNameListener();
                    }
                    ModeImpl.this.addClosedComponent(tc, constraints, orderWeight);
                    ModeImpl.this.setChanged(true);
                }
                ModeImpl.this.changeSupport.firePropertyChange(ModeImpl.PROP_TOP_COMPONENTS, null, null);
            }
        }, new DeferredPerformer.DeferredContext(null, true));
    }

    public boolean close() {
        if (this.closedComponents != null) {
            this.closedComponents.clear();
        }
        if (this.tcc == null) {
            return true;
        }
        TopComponent[] tcs = this.tcc.getTopComponents();
        TopComponent selected = this.tcc.getSelectedTopComponent();
        boolean result = true;
        int i = 0;
        while (i < tcs.length) {
            if (!tcs[i].equals(selected) && !tcs[i].close(this.workspace)) {
                result = false;
            }
            ++i;
        }
        if (selected != null && !selected.close(this.workspace)) {
            result = false;
        }
        return result;
    }

    public void resetComponents() {
        if (this.updater != null) {
            this.updater.resetComponents();
        }
    }

    public boolean isBoundsSet() {
        Rectangle b = this.bounds;
        if (b == null) {
            return false;
        }
        return b.x != 0 || b.y != 0 || b.width != 0 || b.height != 0;
    }

    public void setBounds(Rectangle rect) {
        if (rect == null) {
            throw new NullPointerException("Mode bounds cannot be null!");
        }
        if (this.bounds.equals(rect)) {
            return;
        }
        final Rectangle old = this.bounds;
        this.bounds = rect;
        if (this.frame != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doSetBounds();
                this.changeSupport.firePropertyChange("bounds", old, this.bounds);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ModeImpl.this.doSetBounds();
                        ModeImpl.this.changeSupport.firePropertyChange("bounds", old, ModeImpl.this.bounds);
                    }
                });
            }
        } else {
            this.changeSupport.firePropertyChange("bounds", old, this.bounds);
        }
    }

    public void setNormalBounds(Rectangle rect) {
        if ("org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType)) {
            if (!this.isMaxMode()) {
                this.setBounds(rect);
            } else {
                final Rectangle rLocal = rect;
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        Component comp;
                        if (ModeImpl.this.frame != null && (comp = FrameTypeSupport.obtainFrameComponent(ModeImpl.this.frame)) != null && comp instanceof JInternalFrame) {
                            ((JInternalFrame)comp).setNormalBounds(rLocal);
                        }
                    }
                });
            }
        } else {
            this.setBounds(rect);
        }
    }

    private void doSetBounds() {
        Component comp = FrameTypeSupport.obtainFrameComponent(this.frame);
        if (comp != null) {
            comp.setBounds(this.bounds);
            if (comp instanceof JInternalFrame) {
                ((JInternalFrame)comp).revalidate();
            }
        }
    }

    public void setRelativeBounds(Rectangle rect) {
        Component c;
        int state = StateManager.getDefault().getState();
        if ((state & 1) == 0) {
            this.relativeBounds = rect;
            return;
        }
        this.relativeBounds = rect;
        if (this.relativeBounds == null) {
            return;
        }
        if (!this.boundsConverted) {
            Rectangle wsBounds = null;
            if ("org.netbeans.core.windows.frames.InternalFrameTypeImpl" == this.getFrameType()) {
                Dimension centerSize = ((WorkspaceImpl)this.getWorkspace()).desktopPane().getInnerDesktopSize();
                if (centerSize.width == 0 && centerSize.height == 0) {
                    return;
                }
                wsBounds = new Rectangle(0, 0, centerSize.width, centerSize.height);
            } else {
                wsBounds = ((WorkspaceImpl)this.workspace).getWorkingSpaceBounds();
            }
            Rectangle absoluteBounds = new Rectangle();
            absoluteBounds.x = wsBounds.width * this.relativeBounds.x / 100 + wsBounds.x;
            absoluteBounds.y = wsBounds.height * this.relativeBounds.y / 100 + wsBounds.y;
            absoluteBounds.width = wsBounds.width * this.relativeBounds.width / 100;
            absoluteBounds.height = wsBounds.height * this.relativeBounds.height / 100;
            this.setBounds(absoluteBounds);
            this.boundsConverted = true;
        }
        if (this.frame != null && ModeImpl.handleLayoutResource(c = FrameTypeSupport.obtainFrameComponent(this.frame), this.relativeBounds, this.workspace)) {
            this.relativeBounds = null;
        }
    }

    private static boolean handleLayoutResource(Component c, Rectangle relativeBounds, Workspace ws) {
        if (c instanceof LayoutResource) {
            LayoutResource lr = (LayoutResource)((Object)c);
            lr.setRelativeBounds(relativeBounds);
            lr.setWorkspace(ws);
            return true;
        }
        return false;
    }

    public Rectangle getBounds() {
        this.ensureSectionLoaded(1);
        return (Rectangle)this.bounds.clone();
    }

    public Rectangle getRelativeBounds() {
        int state = StateManager.getDefault().getState();
        if ((state & 1) == 0) {
            return null;
        }
        this.ensureSectionLoaded(1);
        Rectangle rBounds = new Rectangle();
        Rectangle absoluteBounds = new Rectangle(this.bounds);
        Rectangle wsBounds = ((WorkspaceImpl)this.workspace).getWorkingSpaceBounds();
        rBounds.x = 100 * (absoluteBounds.x - wsBounds.x) / wsBounds.width;
        rBounds.y = 100 * (absoluteBounds.y - wsBounds.y) / wsBounds.height;
        rBounds.width = 100 * absoluteBounds.width / wsBounds.width;
        rBounds.height = 100 * absoluteBounds.height / wsBounds.height;
        return rBounds;
    }

    public Rectangle getRelativeBoundsXML() {
        this.ensureSectionLoaded(1);
        return this.relativeBounds;
    }

    public Rectangle getNormalBounds() {
        DesktopPane desktop;
        this.ensureSectionLoaded(1);
        Rectangle result = null;
        if ("org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType) && (desktop = ((WorkspaceImpl)this.workspace).desktopPane()).isMaxMode() && this.frame != null) {
            result = desktop.getFrameBounds(this.frame);
        }
        return result != null ? result : this.getBounds();
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public TopComponent[] getTopComponents() {
        return this.doGetTopComponents(true);
    }

    public TopComponent[] getLoadedTopComponents() {
        return this.doGetTopComponents(false);
    }

    private TopComponent[] doGetTopComponents(boolean load) {
        if (load) {
            this.ensureSectionLoaded(2);
        }
        ArrayList<TopComponent> result = new ArrayList<TopComponent>(Arrays.asList(this.tcc == null ? new TopComponent[]{} : this.tcc.getTopComponents()));
        if (this.closedComponents != null) {
            WeakHashMap weakHashMap = this.closedComponents;
            synchronized (weakHashMap) {
                Iterator it = ((AbstractMap)this.closedComponents).keySet().iterator();
                while (it.hasNext()) {
                    result.add((TopComponent)it.next());
                }
            }
        }
        while (result.remove(null)) {
        }
        return result.toArray(new TopComponent[0]);
    }

    public TopComponent[] getOpenedTopComponents() {
        this.ensureSectionLoaded(2);
        return this.getLoadedOpenedTopComponents();
    }

    public TopComponent[] getLoadedOpenedTopComponents() {
        return this.tcc == null ? new TopComponent[]{} : this.tcc.getTopComponents();
    }

    public String[] getTopComponentIds() {
        this.ensureSectionLoaded(4);
        if (this.topComponentIds == null) {
            this.topComponentIds = new String[0];
        }
        return this.topComponentIds;
    }

    public void setTopComponentIds(String[] topComponentIds) {
        this.topComponentIds = topComponentIds;
    }

    public void requestFocus(final TopComponent comp) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRequestFocus(comp);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModeImpl.this.doRequestFocus(comp);
                }
            });
        }
    }

    public void requestFocus() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRequestFocus();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModeImpl.this.doRequestFocus();
                }
            });
        }
    }

    private void doRequestFocus(TopComponent comp) {
        if (!this.showing) {
            StateManager stateManager = StateManager.getDefault();
            if ((stateManager.getState() & 0x100) == 0 || (stateManager.getState() & 2) != 0) {
                this.deferredFocusRequest = true;
                this.compToReceiveFocus = comp;
            }
        } else if (this.tcc != null && this.tcc.containsTopComponent(comp)) {
            this.requestFocus();
            this.tcc.requestFocus(comp);
        }
    }

    private void doRequestFocus() {
        if (!this.showing) {
            StateManager stateManager = StateManager.getDefault();
            if ((stateManager.getState() & 0x100) == 0 || (stateManager.getState() & 2) != 0) {
                this.deferredFocusRequest = true;
            }
        } else if (this.frame != null) {
            try {
                this.frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void requestVisible(final TopComponent comp) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRequestVisible(comp);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModeImpl.this.doRequestVisible(comp);
                }
            });
        }
    }

    private void doRequestVisible(TopComponent comp) {
        if (this.showing && this.tcc != null && this.tcc.containsTopComponent(comp)) {
            this.tcc.requestVisible(comp);
        }
    }

    public TopComponentContainer getContainerInstance() {
        return this.tcc;
    }

    public FrameType getFrameInstance() {
        return this.frame;
    }

    public String getDisplayNameXML() {
        this.ensureSectionLoaded(1);
        return this.displayName;
    }

    public String getDisplayName() {
        this.ensureSectionLoaded(1);
        if (this.fromBundle) {
            String bName = this.nameBundle;
            if (bName == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("Mode " + this.name + " does not specify nameBundle in xml data!"));
            } else {
                try {
                    return NbBundle.getBundle((String)bName).getString(this.displayName);
                }
                catch (MissingResourceException mre) {
                    ErrorManager.getDefault().annotate((Throwable)mre, 0, "Getting display name for mode " + this.name + " in " + this.getWorkspace().getName(), null, null, null);
                    ErrorManager.getDefault().notify(1, (Throwable)mre);
                }
            }
        }
        return this.displayName;
    }

    public void setDisplayName(String s) {
        String localDisplay = this.getDisplayName();
        if (localDisplay != null) {
            localDisplay = Actions.cutAmpersand((String)localDisplay);
        }
        String inNoShortcut = Actions.cutAmpersand((String)s);
        if (localDisplay != null && localDisplay.equals(inNoShortcut) || localDisplay == null && inNoShortcut == null) {
            return;
        }
        this.fromBundle = false;
        String old = this.displayName;
        this.displayName = s;
        this.changeSupport.firePropertyChange("displayName", old, this.displayName);
    }

    public String getNameBundle() {
        this.ensureSectionLoaded(1);
        return this.nameBundle;
    }

    public void setNameBundle(String nameBundle) {
        this.nameBundle = nameBundle;
    }

    public String getDescriptionXML() {
        this.ensureSectionLoaded(1);
        return this.description;
    }

    public void setDescriptionXML(String s) {
        this.description = s;
    }

    public String getDescription() {
        this.ensureSectionLoaded(1);
        if (this.description == null || this.descriptionBundle == null) {
            ErrorManager.getDefault().log(1, "[WinSys] Mode " + this + " does not provide description in xml data.");
        } else {
            try {
                return NbBundle.getBundle((String)this.descriptionBundle).getString(this.description);
            }
            catch (MissingResourceException mre) {
                ErrorManager.getDefault().notify(1, (Throwable)mre);
            }
        }
        return this.description;
    }

    public String getDescriptionBundle() {
        this.ensureSectionLoaded(1);
        return this.descriptionBundle;
    }

    public void setDescriptionBundle(String descriptionBundle) {
        this.descriptionBundle = descriptionBundle;
    }

    public Image getIcon() {
        this.ensureSectionLoaded(1);
        if (this.iconImage == null && this.icon != null) {
            try {
                this.iconImage = Toolkit.getDefaultToolkit().getImage(this.icon);
            }
            catch (Exception exc) {
                ErrorManager.getDefault().annotate((Throwable)exc, NbBundle.getMessage((Class)(class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = ModeImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl), (String)"FMT_NoIconWarning", (Object[])new Object[]{this.icon}));
                ErrorManager.getDefault().notify(1, (Throwable)exc);
            }
        }
        return this.iconImage;
    }

    public URL getIconURL() {
        this.ensureSectionLoaded(1);
        return this.icon;
    }

    public void setIconURL(URL icon) {
        this.icon = icon;
    }

    public void updateUI() {
        if (this.frame != null) {
            this.frame.updateUI();
        }
    }

    public void setFrameState(final int state) {
        block5: {
            if (this.frame != null) {
                try {
                    if (EventQueue.isDispatchThread()) {
                        this.frame.setState(state);
                        break block5;
                    }
                    EventQueue.invokeLater(new Runnable(){
                        static /* synthetic */ Class class$org$netbeans$core$windows$ModeImpl;

                        public void run() {
                            try {
                                FrameType localFrame = ModeImpl.this.frame;
                                if (localFrame != null) {
                                    localFrame.setState(state);
                                }
                            }
                            catch (PropertyVetoException exc) {
                                ErrorManager em = ErrorManager.getDefault();
                                em.annotate((Throwable)exc, NbBundle.getMessage((Class)(class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = 8.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl), (String)"EXC_SetState", (Object[])new Object[]{ModeImpl.this.getDisplayName()}));
                                em.notify(16, (Throwable)exc);
                            }
                        }

                        static /* synthetic */ Class class$(String x0) {
                            try {
                                return Class.forName(x0);
                            }
                            catch (ClassNotFoundException x1) {
                                throw new NoClassDefFoundError(x1.getMessage());
                            }
                        }
                    });
                }
                catch (PropertyVetoException exc) {
                    ErrorManager em = ErrorManager.getDefault();
                    em.annotate((Throwable)exc, NbBundle.getMessage((Class)(class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = ModeImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl), (String)"EXC_SetState", (Object[])new Object[]{this.getDisplayName()}));
                    em.notify(16, (Throwable)exc);
                }
            } else {
                this.frameTypeState = state;
            }
        }
    }

    public boolean isMaxMode() {
        if (WindowUtils.isMdi()) {
            DesktopPane desktop = ((WorkspaceImpl)this.workspace).desktopPane();
            return desktop.isMaxMode();
        }
        return false;
    }

    public int getRestoredFrameState() {
        this.ensureSectionLoaded(1);
        if (this.frame != null) {
            DesktopPane desktop;
            if ("org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType) && (desktop = ((WorkspaceImpl)this.workspace).desktopPane()).isMaxMode()) {
                return desktop.getFrameState(this.frame);
            }
            return this.frame.getState();
        }
        if (-1 != this.frameTypeState) {
            return this.frameTypeState;
        }
        return 0;
    }

    public int getFrameState() {
        this.ensureSectionLoaded(1);
        if (this.frame != null) {
            return this.frame.getState();
        }
        if (-1 != this.frameTypeState) {
            return this.frameTypeState;
        }
        return 0;
    }

    public void setVisible(boolean state) {
        if (this.isHidden() && this.frame == null) {
            if (this.isUserDefined()) {
                this.destroyMode();
            }
            return;
        }
        this.ensureSectionLoaded(2);
        if (this.isOrphan() || this.frame == null) {
            this.setHidden(true);
            return;
        }
        BoundsConvertor.getInstance().updateBounds(this);
        Component frameComp = FrameTypeSupport.obtainFrameComponent(this.frame);
        if (state != frameComp.isVisible() && (!state || this.shouldShow())) {
            if ("org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(this.frameType) || "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType)) {
                WorkspaceImpl w = (WorkspaceImpl)this.workspace;
                if (state) {
                    if (w.desktopPane().getParent() == null) {
                        MainWindow.getDefault().getContentPane().add(w.desktopPane());
                    }
                    if ("org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(this.frameType)) {
                        Component comp;
                        if (this.constraints instanceof String && (comp = w.desktopPane().getComponentAt((String)this.constraints)) != null) {
                            ModeImpl.handleIssue28872(this, comp, this.constraints);
                            return;
                        }
                        w.desktopPane().addFrameType(this.frame, this.constraints);
                    } else {
                        w.desktopPane().addFrameType(this.frame);
                    }
                } else {
                    w.desktopPane().removeFrameType(this.frame);
                }
                MainWindow.getDefault().invalidate();
                MainWindow.getDefault().validate();
            }
            if (state) {
                this.restoreState();
            }
            this.tcc.setAttached(state);
            frameComp.setVisible(state);
            if (state && Utilities.isUnix() && frameComp instanceof JFrame) {
                ((JFrame)frameComp).requestFocus();
            }
        }
        if (state && this.tcc != null) {
            this.tcc.checkShownComponents();
        }
    }

    private static void handleIssue28872(final ModeImpl newMode, Component oldMode, Object constraints) {
        ErrorManager.getDefault().log(4096, "[WinSys] Mode " + newMode + " attempted to" + " be opened at the position of " + oldMode + ", constraints=" + constraints + ". The mode putting into separate window.");
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                newMode.setFrameType("org.netbeans.core.windows.frames.TopFrameTypeImpl");
                newMode.setVisible(true);
            }
        });
    }

    public boolean isVisible() {
        return this.frame == null ? false : FrameTypeSupport.obtainFrameComponent(this.frame).isVisible();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setTopMaximized() {
        ((WorkspaceImpl)this.workspace).setTopMaximizedMode(this);
    }

    private void restoreState() {
        if (-1 == this.frameTypeState) {
            return;
        }
        if (!"org.netbeans.core.windows.frames.DesktopFrameTypeImpl".equals(this.frameType)) {
            if (this.frameTypeState == 6) {
                WorkspaceImpl w = (WorkspaceImpl)this.workspace;
                w.desktopPane().setMaxMode(true);
            }
            this.setFrameState(this.frameTypeState);
        }
        this.frameTypeState = -1;
    }

    private boolean shouldShow() {
        TopComponent[] tcs = this.tcc.getTopComponents();
        int i = 0;
        while (i < tcs.length) {
            if (WindowManagerImpl.findManager(tcs[i]).isOpened(this.getWorkspace())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isOrphan() {
        this.ensureSectionLoaded(3);
        return this.frame == null || this.tcc == null || this.tcc.getTopComponents().length <= 0;
    }

    public boolean isSingle() {
        this.ensureSectionLoaded(3);
        return this.frame != null && this.tcc != null && this.tcc.getTopComponents().length == 1;
    }

    public boolean isSingleType() {
        if (!this.isSingle()) {
            return false;
        }
        String nameType = (String)this.tcc.getTopComponents()[0].getClientProperty(NAMING_TYPE);
        if (nameType == null) {
            return false;
        }
        if (BOTH_ONLY_COMP_NAME.equals(nameType)) {
            return true;
        }
        if (WindowUtils.isMdi()) {
            return MDI_ONLY_COMP_NAME.equals(nameType);
        }
        return SDI_ONLY_COMP_NAME.equals(nameType);
    }

    public boolean isUserDefined() {
        this.ensureSectionLoaded(1);
        return this.userDefined;
    }

    public boolean isFromBundle() {
        this.ensureSectionLoaded(1);
        return this.fromBundle;
    }

    public void setUserDefined(boolean userDefined) {
        this.userDefined = userDefined;
    }

    public boolean isNameFromBundle() {
        this.ensureSectionLoaded(1);
        return this.fromBundle;
    }

    public void setNameFromBundle(boolean fromBundle) {
        this.fromBundle = fromBundle;
    }

    private Map getClosedComponents() {
        this.ensureSectionLoaded(2);
        return this.closedComponents;
    }

    void fillTopComponents(ModeImpl source) {
        Map closedComps = source.getClosedComponents();
        if (closedComps != null) {
            Map.Entry[] closedEntries = null;
            Map map = closedComps;
            synchronized (map) {
                closedEntries = closedComps.entrySet().toArray(new Map.Entry[closedComps.size()]);
            }
            Object curEntry = null;
            int i = 0;
            while (i < closedEntries.length) {
                ClosedTCContext cc = (ClosedTCContext)closedEntries[i].getValue();
                this.dockInto((TopComponent)closedEntries[i].getKey(), cc.constraints, cc.orderWeight);
                ++i;
            }
        }
        TopComponent[] tcs = source.getOpenedTopComponents();
        int i = 0;
        while (i < tcs.length) {
            this.dockInto(tcs[i], source.tcc.getConstraints(tcs[i]));
            tcs[i].open(this.workspace);
            ++i;
        }
    }

    public void frameDeactivated(FrameTypeEvent fe) {
        this.active = false;
        ((WorkspaceImpl)this.workspace).setActiveMode(null);
    }

    public void frameClosed(FrameTypeEvent fe) {
        if (this.active) {
            this.active = false;
            ((WorkspaceImpl)this.workspace).setActiveMode(null);
        }
    }

    public void frameDeiconified(FrameTypeEvent fe) {
        this.notifyComponentsShowing();
    }

    public void frameNormalized(FrameTypeEvent fe) {
        if (this.frame != null && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType) && this.equals(((WorkspaceImpl)this.workspace).getTopMaximizedMode())) {
            ((WorkspaceImpl)this.workspace).setTopMaximizedMode(null);
        }
    }

    public void frameOpened(FrameTypeEvent fe) {
    }

    public void frameIconified(FrameTypeEvent fe) {
        TopComponent activeTc;
        if (this.frame != null && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType) && this.equals(((WorkspaceImpl)this.workspace).getTopMaximizedMode())) {
            ((WorkspaceImpl)this.workspace).setTopMaximizedMode(null);
        }
        if ((activeTc = TopComponent.getRegistry().getActivated()) != null && this.equals(this.getWorkspace().findMode(activeTc))) {
            WindowManagerImpl.getInstance().activateComponent(null);
        }
        this.notifyComponentsHidden();
    }

    public void frameClosing(FrameTypeEvent fe) {
        if (!this.isInClosableState()) {
            return;
        }
        TopComponent[] tcs = this.tcc.getTopComponents();
        TopComponent selected = this.tcc.getSelectedTopComponent();
        boolean shouldClose = true;
        int i = 0;
        while (i < tcs.length) {
            if (!tcs[i].equals(selected) && !tcs[i].close()) {
                shouldClose = false;
                break;
            }
            ++i;
        }
        if (shouldClose && selected != null && !selected.close()) {
            shouldClose = false;
        }
        if (this.active) {
            this.active = false;
            ((WorkspaceImpl)this.workspace).setActiveMode(null);
        }
    }

    public void frameActivated(FrameTypeEvent fe) {
        this.active = true;
        ((WorkspaceImpl)this.workspace).setActiveMode(this);
    }

    public void frameMaximized(FrameTypeEvent fe) {
        if (this.frame != null && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType)) {
            this.setTopMaximized();
        }
    }

    private void notifyComponentsShowing() {
        if (this.iconifiedShownTcs == null) {
            return;
        }
        WorkspaceImpl ws = (WorkspaceImpl)this.getWorkspace();
        Iterator it = this.iconifiedShownTcs.iterator();
        while (it.hasNext()) {
            ws.addToShownTcs((TopComponent)it.next());
        }
        this.iconifiedShownTcs = null;
    }

    private void notifyComponentsHidden() {
        WorkspaceImpl ws = (WorkspaceImpl)this.getWorkspace();
        Set shownTcs = ws.getShownTcs();
        this.iconifiedShownTcs = new WeakSet(shownTcs.size());
        TopComponent[] tcs = this.getTopComponents();
        int i = 0;
        while (i < tcs.length) {
            if (shownTcs.contains(tcs[i])) {
                ws.removeFromShownTcs(tcs[i]);
                this.iconifiedShownTcs.add(tcs[i]);
            }
            ++i;
        }
    }

    public void componentResized(ComponentEvent ce) {
        this.setBounds(ce.getComponent().getBounds());
    }

    public void componentMoved(ComponentEvent ce) {
        this.setBounds(ce.getComponent().getBounds());
    }

    public void componentShown(ComponentEvent ce) {
        this.showing = true;
        if (this.deferredFocusRequest) {
            this.deferredFocusRequest = false;
            if (this.compToReceiveFocus != null) {
                if (!this.compToReceiveFocus.hasFocus() && SwingUtilities.findFocusOwner((Component)((Object)this.frame)) != null) {
                    this.requestFocus(this.compToReceiveFocus);
                }
                this.compToReceiveFocus = null;
            } else {
                this.requestFocus();
            }
        }
    }

    public void componentHidden(ComponentEvent ce) {
        this.showing = false;
    }

    public void setContainerType(String containerType) {
        if (containerType.equals(this.containerType)) {
            return;
        }
        this.containerType = containerType;
        if (this.tcc != null) {
            TopComponentContainer old = this.tcc;
            this.tcc = this.createContainer(this.containerType);
            this.changeContainer(old, this.tcc);
        }
    }

    public String getContainerType() {
        this.ensureSectionLoaded(1);
        if (this.containerType == null) {
            this.containerType = WindowTypesManager.getDefaultContainer();
        }
        return this.containerType;
    }

    public void setFrameType(String frameType) {
        this.restoreFrameType(this.frameType, frameType);
    }

    public void restoreFrameType(String previousFrameType, String newFrameType) {
        if (newFrameType == null) {
            throw new IllegalArgumentException("Cannot set frame type to null.");
        }
        if (newFrameType.equals(previousFrameType)) {
            return;
        }
        this.frameType = newFrameType;
        DeferredPerformer.getDefault().putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(previousFrameType, true));
    }

    private void doSetFrameType(String oldFrameType) {
        BoundsConvertor.getInstance().updateBounds(this, oldFrameType, this.frameType);
        if (this.frame != null) {
            boolean wasVisible = FrameTypeSupport.obtainFrameComponent(this.frame).isVisible();
            if (wasVisible) {
                this.setVisible(false);
            }
            FrameType old = this.frame;
            this.frame = this.createFrame(this.frameType);
            this.changeFrame(old, this.frame);
            this.doDisposeFrame(old);
            if (wasVisible) {
                this.setVisible(true);
            }
            this.changeSupport.firePropertyChange(PROP_FRAME_INSTANCE, old, this.frame);
        }
    }

    public String getFrameType() {
        this.ensureSectionLoaded(1);
        if (this.frameType == null) {
            this.frameType = WindowTypesManager.getDefaultFrame();
        }
        return this.frameType;
    }

    public void setConstraints(Object constraints) {
        ModeImpl foundMode;
        if (this.constraints == null ? this.constraints == constraints : this.constraints.equals(constraints)) {
            return;
        }
        if (constraints != null && !"CENTER".equals(constraints) && (foundMode = WindowUtils.findConstrainedMode(this.workspace, constraints)) != null && foundMode.isVisible()) {
            throw new IllegalArgumentException("Cannot attach " + this.getDisplayName() + "@" + System.identityHashCode(this) + " to " + constraints + " side. " + foundMode.getDisplayName() + "@" + System.identityHashCode(foundMode) + " is already attached there.");
        }
        Object oldValue = this.constraints;
        if (this.frame != null && FrameTypeSupport.obtainFrameComponent(this.frame).isVisible()) {
            this.setVisible(false);
            this.constraints = constraints;
            this.setVisible(true);
        } else {
            this.constraints = constraints;
        }
        this.changeSupport.firePropertyChange("containerInstance", oldValue, this.constraints);
    }

    public Object getConstraints() {
        this.ensureSectionLoaded(1);
        return this.getLoadedConstraints();
    }

    public void setCurrentConstraints(Object constraints) {
        this.currnetConstraints = constraints;
    }

    public Object getCurrentConstraints() {
        return this.currnetConstraints;
    }

    public Object getLoadedConstraints() {
        return this.constraints;
    }

    public Object getConstraint(TopComponent tc) {
        Object result;
        if (this.tcc != null && (result = this.tcc.getConstraints(tc)) != null) {
            return result;
        }
        if (this.closedComponents != null) {
            ClosedTCContext cc = (ClosedTCContext)this.closedComponents.get(tc);
            return cc == null ? null : cc.constraints;
        }
        return null;
    }

    public boolean isHidden() {
        this.ensureSectionLoaded(1);
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void addPropertyChangeListener(PropertyChangeListener pchl) {
        this.changeSupport.addPropertyChangeListener(pchl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pchl) {
        this.changeSupport.removePropertyChangeListener(pchl);
    }

    public boolean addIgnoredNameClass(Class tcClass) {
        if (this.ignoredTcList == null) {
            this.ignoredTcList = new ArrayList(5);
        }
        if (!(class$org$openide$windows$TopComponent == null ? (class$org$openide$windows$TopComponent = ModeImpl.class$("org.openide.windows.TopComponent")) : class$org$openide$windows$TopComponent).isAssignableFrom(tcClass)) {
            throw new IllegalArgumentException("tcClass parameter is not a subclass of TopComponent class");
        }
        return this.ignoredTcList.add(tcClass);
    }

    public boolean removeIgnoredNameClass(Class tcClass) {
        if (this.ignoredTcList == null) {
            return false;
        }
        return this.ignoredTcList.remove(tcClass);
    }

    void addClosedComponent(TopComponent tc, Object constraints, int orderWeight) {
        if (this.closedComponents == null) {
            this.closedComponents = new WeakHashMap(10);
        }
        WeakHashMap weakHashMap = this.closedComponents;
        synchronized (weakHashMap) {
            ClosedTCContext existing = (ClosedTCContext)this.closedComponents.get(tc);
            if (existing != null) {
                if (constraints != null) {
                    existing.constraints = constraints;
                }
                if (orderWeight != Integer.MAX_VALUE) {
                    existing.orderWeight = orderWeight;
                }
            } else {
                this.closedComponents.put(tc, new ClosedTCContext(constraints, orderWeight));
            }
        }
    }

    ClosedTCContext removeClosedComponent(TopComponent tc) {
        if (this.closedComponents == null) {
            return null;
        }
        WeakHashMap weakHashMap = this.closedComponents;
        synchronized (weakHashMap) {
            ClosedTCContext result = (ClosedTCContext)this.closedComponents.get(tc);
            this.closedComponents.remove(tc);
            ClosedTCContext closedTCContext = result;
            return closedTCContext;
        }
    }

    public void removeAllClosedComponents() {
        if (this.closedComponents != null) {
            this.closedComponents.clear();
        }
    }

    private void addToContainer(TopComponent tc, boolean selectExisting, Object constr, int orderWeight) {
        if (this.frame == null) {
            this.frame = this.createFrame(this.getFrameType());
            this.changeFrame(null, this.frame);
            Image frameIcon = this.obtainFrameIcon(tc);
            if (frameIcon != null) {
                this.frame.setIconImage(frameIcon);
            }
            this.changeSupport.firePropertyChange(PROP_FRAME_INSTANCE, null, this.frame);
        }
        if (this.tcc == null) {
            this.tcc = this.createContainer(this.getContainerType());
            this.changeContainer(null, this.tcc);
        }
        if (constr == null) {
            constr = "CENTER";
        }
        TopComponentContainer.Area area = null;
        if (this.areas != null) {
            area = (TopComponentContainer.Area)this.areas.remove(constr);
        }
        if (constr == null ? this.tcc.addTopComponent(tc, selectExisting) : this.tcc.addTopComponent(tc, selectExisting, constr, orderWeight, area)) {
            this.updateNameListener();
        }
        this.setHidden(false);
    }

    private Image obtainFrameIcon(TopComponent firstTc) {
        Image modeIcon = this.getIcon();
        if (modeIcon != null) {
            return modeIcon;
        }
        Image tcIcon = firstTc.getIcon();
        if (tcIcon != null) {
            return tcIcon;
        }
        return ModeImpl.defaultIcon();
    }

    private static Image defaultIcon() {
        return Utilities.loadImage((String)"org/netbeans/core/resources/frames/default.gif");
    }

    public void setAreas(Map areas) {
        this.areas = new HashMap(areas);
    }

    public Map getAreas() {
        return this.areas;
    }

    private TopComponentContainer createContainer(String className) {
        return WindowTypesManager.createContainer(className);
    }

    private FrameType createFrame(String className) {
        FrameType result = WindowTypesManager.createFrame(className);
        result.setDefaultCloseOperation(0);
        Component frame = FrameTypeSupport.obtainFrameComponent(result);
        frame.setVisible(false);
        frame.setBounds(this.bounds);
        if (this.relativeBounds != null) {
            ModeImpl.handleLayoutResource(frame, this.relativeBounds, this.workspace);
            this.relativeBounds = null;
        }
        result.attachToMode(this);
        return result;
    }

    void setCloseOnlyInMemory(boolean flag) {
        this.closeOnlyInMemory = flag;
    }

    private void destroyMode() {
        ((WorkspaceImpl)this.workspace).removeMode(this);
        if (!this.closeOnlyInMemory && this.updater != null) {
            try {
                this.updater.destroy();
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
        }
    }

    private void destroyFrame() {
        if (this.isUserDefined()) {
            this.destroyMode();
        }
        if (this.frame == null) {
            return;
        }
        this.updateNameListener();
        this.changeFrame(this.frame, null);
        this.frameTypeState = this.frame.getState();
        if (1 == this.frameTypeState) {
            this.frameTypeState = 0;
        }
        this.bounds = this.getNormalBounds();
        this.setHidden(true);
        if (SwingUtilities.isEventDispatchThread()) {
            this.doDisposeFrame(this.frame);
        } else {
            final FrameType localFrame = this.frame;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModeImpl.this.doDisposeFrame(localFrame);
                }
            });
        }
        FrameType old = this.frame;
        this.frame = null;
        this.changeSupport.firePropertyChange(PROP_FRAME_INSTANCE, old, null);
    }

    private void doDisposeFrame(FrameType frame) {
        if (frame instanceof InternalFrameTypeImpl) {
            this.doRemoveInternalFrame((InternalFrameTypeImpl)frame);
        }
        if (frame instanceof LayoutResource) {
            LayoutResource lr = (LayoutResource)((Object)frame);
            lr.setWorkspace(null);
        }
        frame.attachToMode(null);
        frame.dispose();
    }

    private void doRemoveInternalFrame(InternalFrameTypeImpl internalFrame) {
        JDesktopPane desktop = null;
        if (!(internalFrame instanceof DesktopFrameTypeImpl) && internalFrame.isMaximum()) {
            desktop = (JDesktopPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JDesktopPane == null ? (class$javax$swing$JDesktopPane = ModeImpl.class$("javax.swing.JDesktopPane")) : class$javax$swing$JDesktopPane, internalFrame);
        }
        ((WorkspaceImpl)this.workspace).desktopPane().removeFrameType(internalFrame);
        if (desktop != null) {
            JInternalFrame[] allFrames = desktop.getAllFrames();
            if (allFrames.length > 0) {
                ModeImpl m = ((InternalFrameTypeImpl)allFrames[0]).getMode();
                m.setTopMaximized();
            } else {
                ((WorkspaceImpl)this.workspace).setTopMaximizedMode(null);
            }
        }
    }

    private void destroyContainer() {
        if (this.tcc == null) {
            return;
        }
        this.changeContainer(this.tcc, null);
        TopComponentContainer old = this.tcc;
        this.tcc.destroy();
        this.tcc = null;
        this.changeSupport.firePropertyChange("containerInstance", old, null);
    }

    String frameTitle() {
        String selectedName;
        TopComponent selectedTC = this.retrieveSelectedTopComponent();
        String string = selectedName = selectedTC == null ? "?" : selectedTC.getName();
        if (selectedName == null) {
            selectedName = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = ModeImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl), (String)"CTL_UntitledComponent");
        }
        if (this.isSingleType()) {
            return selectedName;
        }
        if (selectedTC != null && this.shouldIgnoreName(selectedTC)) {
            return this.getDisplayName();
        }
        return NbBundle.getMessage((Class)(class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = ModeImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl), (String)"CTL_MultiTabTitle", (Object)this.getDisplayName(), (Object)selectedName);
    }

    private String frameDescription() {
        String selectedDescription;
        TopComponent selectedTC = this.retrieveSelectedTopComponent();
        String string = selectedDescription = selectedTC == null ? "?" : selectedTC.getAccessibleContext().getAccessibleDescription();
        if (selectedDescription == null) {
            return null;
        }
        String modeDescription = this.getDescription();
        if (modeDescription == null) {
            modeDescription = NbBundle.getMessage((Class)(class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = ModeImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl), (String)"ACSD_DefaultModeDescription");
        }
        return NbBundle.getMessage((Class)(class$org$netbeans$core$windows$ModeImpl == null ? (class$org$netbeans$core$windows$ModeImpl = ModeImpl.class$("org.netbeans.core.windows.ModeImpl")) : class$org$netbeans$core$windows$ModeImpl), (String)"ACSD_FrameDescriptionFormat", (Object)modeDescription, (Object)selectedDescription);
    }

    private TopComponent retrieveSelectedTopComponent() {
        TopComponentContainer container = this.getContainerInstance();
        if (container != null) {
            return container.getSelectedTopComponent();
        }
        return null;
    }

    public void updateTitle() {
        if (this.frame != null && "org.netbeans.core.windows.frames.InternalFrameTypeImpl".equals(this.frameType) && this.equals(((WorkspaceImpl)this.workspace).getTopMaximizedMode())) {
            MainWindow.getDefault().updateTitle();
        }
        if (this.frame != null) {
            this.frame.setTitle(this.frameTitle());
            this.frame.getRootPaneContainer().getAccessibleContext().setAccessibleDescription(this.frameDescription());
        }
    }

    public void attachUpdater(LazyUpdater updater) {
        this.updater = updater;
    }

    private void changeFrame(FrameType oldFrame, FrameType newFrame) {
        Image oldIcon = null;
        if (oldFrame != null) {
            if (this.origContentPane != null) {
                oldFrame.setContentPane(this.origContentPane);
                this.origContentPane = null;
            }
            oldFrame.removeFrameTypeListener(this);
            FrameTypeSupport.obtainFrameComponent(oldFrame).removeComponentListener(this);
            oldIcon = oldFrame.getIconImage();
        }
        if (newFrame != null) {
            newFrame.addFrameTypeListener(this);
            FrameTypeSupport.obtainFrameComponent(newFrame).addComponentListener(this);
            TopComponentContainer container = this.getContainerInstance();
            if (container != null) {
                this.origContentPane = newFrame.getContentPane();
                newFrame.setContentPane(container.getContentPane());
                newFrame.setTitle(this.frameTitle());
                newFrame.getRootPaneContainer().getAccessibleContext().setAccessibleDescription(this.frameDescription());
            }
            if (oldIcon != null) {
                newFrame.setIconImage(oldIcon);
            }
            if (oldFrame != null) {
                this.frameTypeState = oldFrame.getState();
            }
        }
    }

    private void changeContainer(TopComponentContainer oldContainer, TopComponentContainer newContainer) {
        if (oldContainer != null) {
            oldContainer.attachToMode(null);
        }
        if (newContainer != null) {
            newContainer.attachToMode(this);
            FrameType frame = this.getFrameInstance();
            if (frame != null) {
                this.origContentPane = frame.getContentPane();
                frame.setContentPane(newContainer.getContentPane());
                frame.setTitle(this.frameTitle());
                frame.getRootPaneContainer().getAccessibleContext().setAccessibleDescription(this.frameDescription());
            }
        }
    }

    public boolean shouldIgnoreName(TopComponent tc) {
        if (!this.isSingle()) {
            return false;
        }
        String dName = this.getDisplayName();
        return dName != null && dName.equalsIgnoreCase(tc.getName()) || this.ignoredTcList != null && this.ignoredTcList.contains(tc.getClass());
    }

    private void updateNameListener() {
        if (this.isSingle()) {
            if (this.nameListener == null) {
                this.nameListener = new NameListener();
            }
            this.nameListener.activate();
        } else if (this.nameListener != null) {
            this.nameListener.passivate();
        }
        this.changeSupport.firePropertyChange("displayName", null, this.getDisplayName());
    }

    public void performCommand(DeferredPerformer.DeferredContext context) {
        Object data = context.getData();
        if (data instanceof DeferredOpenContext) {
            DeferredOpenContext openContext = (DeferredOpenContext)data;
            openContext.tc.open(openContext.workspace);
        } else if (data instanceof String) {
            this.doSetFrameType((String)data);
        }
    }

    private boolean isInClosableState() {
        return NbPresenter.currentModalDialog == null;
    }

    private boolean ensureSectionLoaded(int section) {
        if (this.updater == null) {
            return false;
        }
        try {
            if (!this.updater.isValid()) {
                return false;
            }
            if ((section & this.updater.getLoadedSections()) != section) {
                this.updater.loadDataSection(section);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + ", workspace " + (this.workspace != null ? this.workspace.getName() : "null") + "]";
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer(this);
    }

    void validateSelf(Workspace workspace) {
        this.workspace = workspace;
    }

    void validateData() {
        if (this.tcc != null) {
            TopComponent[] tcs;
            this.tcc.validateData();
            if (this.tcc instanceof MultiTabbedContainerImpl && null != this.containerType && this.containerType.equals("org.netbeans.core.windows.frames.SplitContainerImpl")) {
                TopComponentContainer newTcc = this.createContainer(this.containerType);
                tcs = this.tcc.getTopComponents();
                newTcc.attachToMode(this);
                int i = 0;
                while (i < tcs.length) {
                    newTcc.addTopComponent(tcs[i], true, "CENTER");
                    ++i;
                }
                this.tcc = newTcc;
            }
            if (this.tcc.getTopComponents().length > 0) {
                final TopComponent tc = this.tcc.getSelectedTopComponent();
                tcs = this.tcc.getTopComponents();
                DeferredPerformer deferredPerformer = DeferredPerformer.getDefault();
                DeferredOpenContext openContext = null;
                int i = 0;
                while (i < tcs.length) {
                    openContext = new DeferredOpenContext();
                    openContext.tc = tcs[i];
                    openContext.workspace = this.workspace;
                    deferredPerformer.putRequest((DeferredPerformer.DeferredCommand)this, new DeferredPerformer.DeferredContext(openContext, true));
                    ++i;
                }
                if (tc != null) {
                    deferredPerformer.putRequest(new DeferredPerformer.DeferredCommand(){

                        public void performCommand(DeferredPerformer.DeferredContext dc) {
                            ModeImpl modeImpl = ModeImpl.this;
                            synchronized (modeImpl) {
                                if (ModeImpl.this.tcc == null) {
                                    return;
                                }
                                ModeImpl.this.requestFocus(tc);
                            }
                        }
                    }, new DeferredPerformer.DeferredContext(null, true));
                }
            } else {
                this.tcc = null;
            }
        }
        if (this.frame != null) {
            this.frame.addFrameTypeListener(this);
            FrameTypeSupport.obtainFrameComponent(this.frame).addComponentListener(this);
        }
        this.changeSupport.firePropertyChange("containerInstance", null, this.tcc);
        this.changeSupport.firePropertyChange(PROP_FRAME_INSTANCE, null, this.frame);
        this.changeSupport.firePropertyChange(PROP_TOP_COMPONENTS, null, null);
    }

    private VersionSerializator serializationManager() {
        if (serializationManager == null) {
            serializationManager = ModeImpl.createSerializationManager();
        }
        return serializationManager;
    }

    private static VersionSerializator createSerializationManager() {
        VersionSerializator result = new VersionSerializator();
        result.putVersion(new Version1());
        result.putVersion(new Version2());
        return result;
    }

    public int compareTo(Object obj) {
        String arg1 = this.getDisplayName();
        String arg2 = obj instanceof Mode ? ((Mode)obj).getDisplayName() : null;
        if (arg2 == null) {
            if (arg1 == null) {
                return 0;
            }
            return 1;
        }
        if (arg1 == null) {
            return -1;
        }
        return arg1.compareTo(arg2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class VSAccess
    implements DefaultReplacer.Access {
        transient VersionSerializator vs;
        private static final long serialVersionUID = -7577235918945664917L;

        public VSAccess(VersionSerializator vs) {
            this.vs = vs;
        }

        public VersionSerializator getVersionSerializator() {
            return this.vs == null ? ModeImpl.createSerializationManager() : this.vs;
        }
    }

    private static class Version2
    extends Version1 {
        public static final String NAME = "Version_2.0";
        List ignoredTcList;
        static /* synthetic */ Class class$java$lang$ClassLoader;

        Version2() {
        }

        public String getName() {
            return NAME;
        }

        public void readData(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readData(in);
            ArrayList readList = (ArrayList)in.readObject();
            if (readList == null || readList.size() <= 0 || readList.get(0) instanceof Class) {
                this.ignoredTcList = readList;
            } else {
                this.ignoredTcList = new ArrayList(readList.size());
                String curName = null;
                Iterator iter = ((AbstractList)readList).iterator();
                while (iter.hasNext()) {
                    curName = (String)iter.next();
                    this.ignoredTcList.add(Class.forName(curName, false, (ClassLoader)Lookup.getDefault().lookup(class$java$lang$ClassLoader == null ? Version2.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader)));
                }
            }
        }

        public void writeData(ObjectOutput out) throws IOException {
            super.writeData(out);
            ArrayList<String> ignoredNames = null;
            if (this.mode.ignoredTcList != null) {
                ignoredNames = new ArrayList<String>(this.mode.ignoredTcList.size());
                String curName = null;
                Iterator iter = this.mode.ignoredTcList.iterator();
                while (iter.hasNext()) {
                    curName = ((Class)iter.next()).getName();
                    ignoredNames.add(curName);
                }
            }
            out.writeObject(ignoredNames);
        }

        public Object resolveData() throws ObjectStreamException {
            ModeImpl result = (ModeImpl)super.resolveData();
            if (result.ignoredTcList == null) {
                result.ignoredTcList = this.ignoredTcList;
            } else if (this.ignoredTcList != null) {
                result.ignoredTcList.addAll(this.ignoredTcList);
            }
            return result;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class Version1
    implements DefaultReplacer.ResVersionable {
        public static final String NAME = "Version_1.0";
        String name;
        String displayName;
        Rectangle bounds;
        URL icon;
        int containerType;
        boolean userDefined;
        String workspaceName;
        TopComponentContainer tcc;
        ModeImpl mode;

        Version1() {
        }

        public String getName() {
            return NAME;
        }

        public void assignData(ModeImpl mode) {
            this.mode = mode;
        }

        public void readData(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = (String)in.readObject();
            this.displayName = (String)in.readObject();
            this.bounds = (Rectangle)in.readObject();
            this.icon = (URL)in.readObject();
            this.containerType = (Integer)in.readObject();
            this.userDefined = (Boolean)in.readObject();
            this.workspaceName = (String)in.readObject();
            this.tcc = (TopComponentContainer)in.readObject();
        }

        public void writeData(ObjectOutput out) throws IOException {
            throw new InternalError();
        }

        public Object resolveData() throws ObjectStreamException {
            ModeImpl result;
            Workspace workspace = WindowManager.getDefault().findWorkspace(this.workspaceName);
            ModeImpl modeImpl = result = workspace == null ? null : (ModeImpl)workspace.findMode(this.name);
            if (result == null) {
                result = new ModeImpl(this.name, this.displayName, this.icon, this.userDefined, workspace);
                if (workspace == null) {
                    result.workspaceName = this.workspaceName;
                }
            }
            if (null != result) {
                result.bounds = this.bounds == null ? new Rectangle() : this.bounds;
                result.tcc = this.tcc;
            }
            return result;
        }
    }

    private static final class SerializationReplacer
    implements Serializable {
        static final long serialVersionUID = 1230255666898346575L;
        private static final String NAME = "name";
        private static final String DISPLAY_NAME = "displayName";
        private static final String BOUNDS = "bounds";
        private static final String ICON_URL = "iconURL";
        private static final String USER_DEFINED = "userDefined";
        private static final String WORKSPACE_NAME = "workspaceName";
        private static final String TC_CONTAINER = "tcContainer";
        private static final String FRAME_TYPE = "frameType";
        private static final String FRAME_TYPE_STATE = "frameTypeState";
        private static final String CONTAINER_TYPE = "containerType";
        private static final String CONSTRAINTS = "constraints";
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("displayName", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("bounds", class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = SerializationReplacer.class$("java.awt.Rectangle")) : class$java$awt$Rectangle), new ObjectStreamField("iconURL", class$java$net$URL == null ? (class$java$net$URL = SerializationReplacer.class$("java.net.URL")) : class$java$net$URL), new ObjectStreamField("userDefined", class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializationReplacer.class$("java.lang.Boolean")) : class$java$lang$Boolean), new ObjectStreamField("workspaceName", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("tcContainer", class$org$netbeans$core$windows$frames$TopComponentContainer == null ? (class$org$netbeans$core$windows$frames$TopComponentContainer = SerializationReplacer.class$("org.netbeans.core.windows.frames.TopComponentContainer")) : class$org$netbeans$core$windows$frames$TopComponentContainer), new ObjectStreamField("frameType", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("frameTypeState", class$java$lang$Integer == null ? (class$java$lang$Integer = SerializationReplacer.class$("java.lang.Integer")) : class$java$lang$Integer), new ObjectStreamField("containerType", class$java$lang$String == null ? (class$java$lang$String = SerializationReplacer.class$("java.lang.String")) : class$java$lang$String), new ObjectStreamField("constraints", class$java$lang$Object == null ? (class$java$lang$Object = SerializationReplacer.class$("java.lang.Object")) : class$java$lang$Object)};
        private static final String OLD_SPLIT_CONTAINER = "org.netbeans.core.windows.frames.SplittedContainerImpl";
        transient ModeImpl source;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$awt$Rectangle;
        static /* synthetic */ Class class$java$net$URL;
        static /* synthetic */ Class class$java$lang$Boolean;
        static /* synthetic */ Class class$org$netbeans$core$windows$frames$TopComponentContainer;
        static /* synthetic */ Class class$java$lang$Integer;
        static /* synthetic */ Class class$java$lang$Object;

        SerializationReplacer(ModeImpl source) {
            this.source = source;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            ObjectOutputStream.PutField pf = oos.putFields();
            pf.put(NAME, this.source.getName());
            pf.put(DISPLAY_NAME, this.source.getDisplayName());
            pf.put(BOUNDS, this.source.getNormalBounds());
            pf.put(ICON_URL, this.source.getIconURL());
            pf.put(USER_DEFINED, this.source.isUserDefined() ? Boolean.TRUE : Boolean.FALSE);
            pf.put(WORKSPACE_NAME, this.source.workspace.getName());
            pf.put(TC_CONTAINER, this.source.tcc);
            pf.put(FRAME_TYPE, this.source.getFrameType());
            pf.put(FRAME_TYPE_STATE, new Integer(this.source.getFrameState()));
            pf.put(CONTAINER_TYPE, this.source.getContainerType());
            pf.put(CONSTRAINTS, this.source.getConstraints());
            oos.writeFields();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ObjectInputStream.GetField gf = ois.readFields();
            String name = (String)gf.get(NAME, null);
            String workspaceName = (String)gf.get(WORKSPACE_NAME, null);
            Workspace workspace = WindowManager.getDefault().findWorkspace(workspaceName);
            ModeImpl modeImpl = this.source = workspace == null ? null : (ModeImpl)workspace.findMode(name);
            if (this.source == null) {
                this.source = new ModeImpl(name, (String)gf.get(DISPLAY_NAME, null), (URL)gf.get(ICON_URL, null), (Boolean)gf.get(USER_DEFINED, null), workspace);
            } else {
                this.source.close();
                this.source.destroyFrame();
                this.source.destroyContainer();
                this.source.setDisplayName((String)gf.get(DISPLAY_NAME, null));
            }
            Rectangle bounds = (Rectangle)gf.get(BOUNDS, null);
            this.source.setBounds(bounds == null ? new Rectangle() : bounds);
            this.source.frameType = (String)gf.get(FRAME_TYPE, null);
            this.source.containerType = (String)gf.get(CONTAINER_TYPE, null);
            if (OLD_SPLIT_CONTAINER.equals(this.source.containerType)) {
                this.source.containerType = "org.netbeans.core.windows.frames.SplitContainerImpl";
            }
            this.source.constraints = gf.get(CONSTRAINTS, null);
            this.source.tcc = (TopComponentContainer)gf.get(TC_CONTAINER, null);
            if (workspace == null) {
                this.source.workspaceName = workspaceName;
            }
            if (null != this.source.frameType && WindowUtils.hasObjectStreamField(gf, FRAME_TYPE_STATE)) {
                this.source.frameTypeState = (Integer)gf.get(FRAME_TYPE_STATE, new Integer(0));
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.source;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static final class ClosedTCContext {
        Object constraints;
        int orderWeight;

        ClosedTCContext(Object constraints, int orderWeight) {
            this.constraints = constraints;
            this.orderWeight = orderWeight;
        }
    }

    public static final class ModeDefinition {
        String name;
        String displayName;
        URL iconURL;
        String containerType;
        Object constraints;
    }

    private final class NameListener
    implements PropertyChangeListener {
        WindowManagerImpl.TopComponentManager tcm;

        NameListener() {
        }

        void activate() {
            if (this.tcm == null) {
                this.tcm = WindowManagerImpl.findManager(ModeImpl.this.tcc.getTopComponents()[0]);
                this.tcm.addPropertyChangeListener(this);
            }
        }

        void passivate() {
            if (this.tcm != null) {
                this.tcm.removePropertyChangeListener(this);
                this.tcm = null;
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("name".equals(propName)) {
                this.updateFrameTitle();
                ModeImpl.this.changeSupport.firePropertyChange("displayName", evt.getOldValue(), evt.getNewValue());
            }
        }

        private void updateFrameTitle() {
            FrameType f = ModeImpl.this.frame;
            if (f == null) {
                return;
            }
            String title = ModeImpl.this.frameTitle();
            if (SwingUtilities.isEventDispatchThread()) {
                f.setTitle(title);
            } else {
                SwingUtilities.invokeLater(new Runnable(this, f, title){
                    private final /* synthetic */ FrameType val$f;
                    private final /* synthetic */ String val$title;
                    private final /* synthetic */ NameListener this$1;
                    {
                        this.this$1 = this$1;
                        this.val$f = val$f;
                        this.val$title = val$title;
                    }

                    public void run() {
                        this.val$f.setTitle(this.val$title);
                    }
                });
            }
        }
    }

    private static final class DeferredOpenContext {
        TopComponent tc;
        Workspace workspace;

        DeferredOpenContext() {
        }
    }
}

